/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.ConfigUtil;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.InfoPreviewResult;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.PreviewResult;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.catalog.ElasticSearchTypeConverter;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.EsRestClient;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.EsType;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.dto.ElasticsearchClusterInfo;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.dto.source.IndexDocsCount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchCatalog
implements Catalog {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchCatalog.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchCatalog.class);
    private final String catalogName;
    private final String defaultDatabase;
    private final ReadonlyConfig config;
    private EsRestClient esRestClient;

    public ElasticSearchCatalog(String catalogName, String defaultDatabase, ReadonlyConfig config) {
        this.catalogName = Preconditions.checkNotNull(catalogName, "catalogName cannot be null");
        this.defaultDatabase = defaultDatabase;
        this.config = Preconditions.checkNotNull(config, "elasticSearchConfig cannot be null");
    }

    public void open() throws CatalogException {
        try {
            this.esRestClient = EsRestClient.createInstance(this.config);
            ElasticsearchClusterInfo elasticsearchClusterInfo = this.esRestClient.getClusterInfo();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Success open es catalog: {}, cluster info: {}", (Object)this.catalogName, (Object)elasticsearchClusterInfo);
            }
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed to open catalog %s", this.catalogName), (Throwable)e);
        }
    }

    public void close() throws CatalogException {
        this.esRestClient.close();
    }

    public String name() {
        return this.catalogName;
    }

    public String getDefaultDatabase() throws CatalogException {
        return this.defaultDatabase;
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        try {
            List<IndexDocsCount> indexDocsCount = this.esRestClient.getIndexDocsCount(databaseName);
            return true;
        }
        catch (Exception e) {
            log.error(String.format("Failed to check if catalog %s database %s exists", this.catalogName, databaseName), (Throwable)e);
            return false;
        }
    }

    public List<String> listDatabases() throws CatalogException {
        return this.esRestClient.listIndex();
    }

    public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.catalogName, databaseName);
        }
        return Lists.newArrayList(databaseName);
    }

    public boolean tableExists(TablePath tablePath) throws CatalogException {
        Preconditions.checkNotNull(tablePath);
        return this.databaseExists(tablePath.getTableName());
    }

    public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
        Preconditions.checkNotNull(tablePath, "tablePath cannot be null");
        TableSchema.Builder builder = TableSchema.builder();
        Map<String, BasicTypeDefine<EsType>> fieldTypeMapping = this.esRestClient.getFieldTypeMapping(tablePath.getTableName(), Collections.emptyList());
        this.buildColumnsWithErrorCheck(tablePath, builder, fieldTypeMapping.entrySet().iterator(), nameAndType -> PhysicalColumn.of((String)((String)nameAndType.getKey()), (SeaTunnelDataType)ElasticSearchTypeConverter.INSTANCE.convert((BasicTypeDefine<EsType>)((BasicTypeDefine)nameAndType.getValue())).getDataType(), (Long)null, (boolean)true, null, null));
        return CatalogTable.of((TableIdentifier)TableIdentifier.of((String)this.catalogName, (String)tablePath.getDatabaseName(), (String)tablePath.getTableName()), (TableSchema)builder.build(), this.buildTableOptions(tablePath), Collections.emptyList(), (String)"");
    }

    public void createTable(TablePath tablePath, CatalogTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        Preconditions.checkNotNull(tablePath, "tablePath cannot be null");
        this.esRestClient.createIndex(tablePath.getTableName());
    }

    public void dropTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        Preconditions.checkNotNull(tablePath);
        if (!this.tableExists(tablePath) && !ignoreIfNotExists) {
            throw new TableNotExistException(this.catalogName, tablePath);
        }
        try {
            this.esRestClient.dropIndex(tablePath.getTableName());
        }
        catch (Exception ex) {
            throw new CatalogException(String.format("Failed to drop table %s in catalog %s", tablePath.getTableName(), this.catalogName), (Throwable)ex);
        }
    }

    public void createDatabase(TablePath tablePath, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        this.createTable(tablePath, null, ignoreIfExists);
    }

    public void dropDatabase(TablePath tablePath, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        this.dropTable(tablePath, ignoreIfNotExists);
    }

    public void truncateTable(TablePath tablePath, boolean ignoreIfNotExists) {
        this.esRestClient.clearIndexData(tablePath.getTableName());
    }

    public boolean isExistsData(TablePath tablePath) {
        List<IndexDocsCount> indexDocsCount = this.esRestClient.getIndexDocsCount(tablePath.getTableName());
        return indexDocsCount.get(0).getDocsCount() > 0L;
    }

    private Map<String, String> buildTableOptions(TablePath tablePath) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("connector", "elasticsearch");
        options.put("config", ConfigUtil.convertToJsonString((Object)tablePath));
        return options;
    }

    public PreviewResult previewAction(Catalog.ActionType actionType, TablePath tablePath, Optional<CatalogTable> catalogTable) {
        if (actionType == Catalog.ActionType.CREATE_TABLE) {
            return new InfoPreviewResult("create index " + tablePath.getTableName());
        }
        if (actionType == Catalog.ActionType.DROP_TABLE) {
            return new InfoPreviewResult("delete index " + tablePath.getTableName());
        }
        if (actionType == Catalog.ActionType.TRUNCATE_TABLE) {
            return new InfoPreviewResult("delete and create index " + tablePath.getTableName());
        }
        if (actionType == Catalog.ActionType.CREATE_DATABASE) {
            return new InfoPreviewResult("create index " + tablePath.getTableName());
        }
        if (actionType == Catalog.ActionType.DROP_DATABASE) {
            return new InfoPreviewResult("delete index " + tablePath.getTableName());
        }
        throw new UnsupportedOperationException("Unsupported action type: " + actionType);
    }
}

