/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.sink;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.sink.SinkCommonOptions;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSinkFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.EsClusterConnectionConfig;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.SinkConfig;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.sink.ElasticsearchSink;

@AutoService(value={Factory.class})
public class ElasticsearchSinkFactory
implements TableSinkFactory {
    public String factoryIdentifier() {
        return "Elasticsearch";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{EsClusterConnectionConfig.HOSTS, SinkConfig.INDEX, SinkConfig.SCHEMA_SAVE_MODE, SinkConfig.DATA_SAVE_MODE}).optional(new Option[]{SinkConfig.INDEX_TYPE, SinkConfig.PRIMARY_KEYS, SinkConfig.KEY_DELIMITER, EsClusterConnectionConfig.USERNAME, EsClusterConnectionConfig.PASSWORD, SinkConfig.MAX_RETRY_COUNT, SinkConfig.MAX_BATCH_SIZE, EsClusterConnectionConfig.TLS_VERIFY_CERTIFICATE, EsClusterConnectionConfig.TLS_VERIFY_HOSTNAME, EsClusterConnectionConfig.TLS_KEY_STORE_PATH, EsClusterConnectionConfig.TLS_KEY_STORE_PASSWORD, EsClusterConnectionConfig.TLS_TRUST_STORE_PATH, EsClusterConnectionConfig.TLS_TRUST_STORE_PASSWORD, SinkCommonOptions.MULTI_TABLE_SINK_REPLICA}).build();
    }

    public TableSink createSink(TableSinkFactoryContext context) {
        ReadonlyConfig readonlyConfig = context.getOptions();
        String original = (String)readonlyConfig.get(SinkConfig.INDEX);
        CatalogTable newTable = CatalogTable.of((TableIdentifier)TableIdentifier.of((String)context.getCatalogTable().getCatalogName(), (String)context.getCatalogTable().getTablePath().getDatabaseName(), (String)original), (CatalogTable)context.getCatalogTable());
        return () -> new ElasticsearchSink(readonlyConfig, newTable);
    }
}

