/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.type.TypeReference;

public class SourceConfig
implements Serializable {
    public static final Option<List<Map<String, Object>>> INDEX_LIST = Options.key((String)"index_list").type((TypeReference)new TypeReference<List<Map<String, Object>>>(){}).noDefaultValue().withDescription("index_list for multiTable sync");
    public static final Option<String> INDEX = Options.key((String)"index").stringType().noDefaultValue().withDescription("Elasticsearch index name, support * fuzzy matching");
    public static final Option<List<String>> SOURCE = Options.key((String)"source").listType().noDefaultValue().withDescription("The fields of index. You can get the document id by specifying the field _id.If sink _id to other index,you need specify an alias for _id due to the Elasticsearch limit");
    public static final Option<Map<String, String>> ARRAY_COLUMN = Options.key((String)"array_column").mapType().defaultValue(new HashMap()).withDescription("Because there is no array type in es,so need specify array Type.");
    public static final Option<String> SCROLL_TIME = Options.key((String)"scroll_time").stringType().defaultValue((Object)"1m").withDescription("Amount of time Elasticsearch will keep the search context alive for scroll requests");
    public static final Option<Integer> SCROLL_SIZE = Options.key((String)"scroll_size").intType().defaultValue((Object)100).withDescription("Maximum number of hits to be returned with each Elasticsearch scroll request");
    public static final Option<Map<String, Object>> QUERY = Options.key((String)"query").type((TypeReference)new TypeReference<Map<String, Object>>(){}).defaultValue(Collections.singletonMap("match_all", new HashMap())).withDescription("Elasticsearch query language. You can control the range of data read");
    private String index;
    private List<String> source;
    private Map<String, Object> query;
    private String scrollTime;
    private int scrollSize;
    private CatalogTable catalogTable;

    public SourceConfig clone() {
        SourceConfig sourceConfig = new SourceConfig();
        sourceConfig.setIndex(this.index);
        sourceConfig.setSource(new ArrayList<String>(this.source));
        sourceConfig.setQuery(new HashMap<String, Object>(this.query));
        sourceConfig.setScrollTime(this.scrollTime);
        sourceConfig.setScrollSize(this.scrollSize);
        sourceConfig.setCatalogTable(this.catalogTable);
        return sourceConfig;
    }

    public String getIndex() {
        return this.index;
    }

    public List<String> getSource() {
        return this.source;
    }

    public Map<String, Object> getQuery() {
        return this.query;
    }

    public String getScrollTime() {
        return this.scrollTime;
    }

    public int getScrollSize() {
        return this.scrollSize;
    }

    public CatalogTable getCatalogTable() {
        return this.catalogTable;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public void setSource(List<String> source) {
        this.source = source;
    }

    public void setQuery(Map<String, Object> query) {
        this.query = query;
    }

    public void setScrollTime(String scrollTime) {
        this.scrollTime = scrollTime;
    }

    public void setScrollSize(int scrollSize) {
        this.scrollSize = scrollSize;
    }

    public void setCatalogTable(CatalogTable catalogTable) {
        this.catalogTable = catalogTable;
    }
}

