/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.constant;

import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.exception.ElasticsearchConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.exception.ElasticsearchConnectorException;

public enum ElasticsearchVersion {
    ES2(2),
    ES5(5),
    ES6(6),
    ES7(7),
    ES8(8);

    private int version;

    private ElasticsearchVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public static ElasticsearchVersion get(int version) {
        for (ElasticsearchVersion elasticsearchVersion : ElasticsearchVersion.values()) {
            if (elasticsearchVersion.getVersion() != version) continue;
            return elasticsearchVersion;
        }
        throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.GET_ES_VERSION_FAILED, String.format("version=%d,fail fo find ElasticsearchVersion.", version));
    }

    public static ElasticsearchVersion get(String clusterVersion) {
        String[] versionArr = clusterVersion.split("\\.");
        int version = Integer.parseInt(versionArr[0]);
        return ElasticsearchVersion.get(version);
    }
}

