/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.constant;

import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.exception.ElasticsearchConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.exception.ElasticsearchConnectorException;

public class EsTypeMappingSeaTunnelType {
    private static final Map<String, SeaTunnelDataType> MAPPING = new HashMap(){
        {
            this.put("string", BasicType.STRING_TYPE);
            this.put("keyword", BasicType.STRING_TYPE);
            this.put("text", BasicType.STRING_TYPE);
            this.put("binary", BasicType.STRING_TYPE);
            this.put("boolean", BasicType.BOOLEAN_TYPE);
            this.put("byte", BasicType.BYTE_TYPE);
            this.put("short", BasicType.SHORT_TYPE);
            this.put("integer", BasicType.INT_TYPE);
            this.put("long", BasicType.LONG_TYPE);
            this.put("float", BasicType.FLOAT_TYPE);
            this.put("half_float", BasicType.FLOAT_TYPE);
            this.put("double", BasicType.DOUBLE_TYPE);
            this.put("date", LocalTimeType.LOCAL_DATE_TIME_TYPE);
        }
    };

    public static SeaTunnelDataType getSeaTunnelDataType(String esType) {
        SeaTunnelDataType seaTunnelDataType = MAPPING.get(esType);
        if (seaTunnelDataType == null) {
            throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.ES_FIELD_TYPE_NOT_SUPPORT, String.format("elasticsearch type is %s", esType));
        }
        return seaTunnelDataType;
    }
}

