/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.sink.SupportMultiTableSinkWriter;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.EsRestClient;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.dto.BulkResponse;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.dto.IndexInfo;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.exception.ElasticsearchConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.exception.ElasticsearchConnectorException;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.serialize.ElasticsearchRowSerializer;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.serialize.SeaTunnelRowSerializer;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.state.ElasticsearchCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.state.ElasticsearchSinkState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchSinkWriter
implements SinkWriter<SeaTunnelRow, ElasticsearchCommitInfo, ElasticsearchSinkState>,
SupportMultiTableSinkWriter<Void> {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchSinkWriter.class);
    private final SinkWriter.Context context;
    private final int maxBatchSize;
    private final SeaTunnelRowSerializer seaTunnelRowSerializer;
    private final List<String> requestEsList;
    private EsRestClient esRestClient;
    private RetryUtils.RetryMaterial retryMaterial;
    private static final long DEFAULT_SLEEP_TIME_MS = 200L;

    public ElasticsearchSinkWriter(SinkWriter.Context context, CatalogTable catalogTable, ReadonlyConfig config, int maxBatchSize, int maxRetryCount) {
        this.context = context;
        this.maxBatchSize = maxBatchSize;
        IndexInfo indexInfo = new IndexInfo(catalogTable.getTableId().getTableName(), config);
        this.esRestClient = EsRestClient.createInstance(config);
        this.seaTunnelRowSerializer = new ElasticsearchRowSerializer(this.esRestClient.getClusterInfo(), indexInfo, catalogTable.getSeaTunnelRowType());
        this.requestEsList = new ArrayList<String>(maxBatchSize);
        this.retryMaterial = new RetryUtils.RetryMaterial(maxRetryCount, true, exception -> true, 200L);
    }

    public void write(SeaTunnelRow element) {
        if (RowKind.UPDATE_BEFORE.equals((Object)element.getRowKind())) {
            return;
        }
        String indexRequestRow = this.seaTunnelRowSerializer.serializeRow(element);
        this.requestEsList.add(indexRequestRow);
        if (this.requestEsList.size() >= this.maxBatchSize) {
            this.bulkEsWithRetry(this.esRestClient, this.requestEsList);
        }
    }

    public Optional<ElasticsearchCommitInfo> prepareCommit() {
        this.bulkEsWithRetry(this.esRestClient, this.requestEsList);
        return Optional.empty();
    }

    public void abortPrepare() {
    }

    public synchronized void bulkEsWithRetry(EsRestClient esRestClient, List<String> requestEsList) {
        try {
            RetryUtils.retryWithException(() -> {
                if (requestEsList.size() > 0) {
                    String requestBody = String.join((CharSequence)"\n", requestEsList) + "\n";
                    BulkResponse bulkResponse = esRestClient.bulk(requestBody);
                    if (bulkResponse.isErrors()) {
                        throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.BULK_RESPONSE_ERROR, "bulk es error: " + bulkResponse.getResponse());
                    }
                    return bulkResponse;
                }
                return null;
            }, (RetryUtils.RetryMaterial)this.retryMaterial);
            requestEsList.clear();
        }
        catch (Exception e) {
            throw new ElasticsearchConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.SQL_OPERATION_FAILED, "ElasticSearch execute batch statement error", e);
        }
    }

    public void close() throws IOException {
        this.bulkEsWithRetry(this.esRestClient, this.requestEsList);
        this.esRestClient.close();
    }
}

