/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.source.SupportColumnProjection;
import org.apache.seatunnel.api.source.SupportParallelism;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.SeaTunnelDataTypeConvertorUtil;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.schema.TableSchemaOptions;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.catalog.ElasticSearchTypeConverter;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.EsRestClient;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.EsType;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.SourceConfig;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.exception.ElasticsearchConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.exception.ElasticsearchConnectorException;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.source.ElasticsearchSourceReader;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.source.ElasticsearchSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.source.ElasticsearchSourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.source.ElasticsearchSourceState;
import org.apache.seatunnel.shade.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchSource
implements SeaTunnelSource<SeaTunnelRow, ElasticsearchSourceSplit, ElasticsearchSourceState>,
SupportParallelism,
SupportColumnProjection {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchSource.class);
    private final List<SourceConfig> sourceConfigList;
    private final ReadonlyConfig connectionConfig;

    public ElasticsearchSource(ReadonlyConfig config) {
        this.connectionConfig = config;
        boolean multiSource = config.getOptional(SourceConfig.INDEX_LIST).isPresent();
        boolean singleSource = config.getOptional(SourceConfig.INDEX).isPresent();
        if (multiSource && singleSource) {
            log.warn("Elasticsearch Source config warn: when both 'index' and 'index_list' are present in the configuration, only the 'index_list' configuration will take effect");
        }
        if (!multiSource && !singleSource) {
            throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.SOURCE_CONFIG_ERROR_01, ElasticsearchConnectorErrorCode.SOURCE_CONFIG_ERROR_01.getDescription());
        }
        this.sourceConfigList = multiSource ? this.createMultiSource(config) : Collections.singletonList(this.parseOneIndexQueryConfig(config));
    }

    private List<SourceConfig> createMultiSource(ReadonlyConfig config) {
        List configMaps = (List)config.get(SourceConfig.INDEX_LIST);
        List configList = configMaps.stream().map(ReadonlyConfig::fromMap).collect(Collectors.toList());
        ArrayList<SourceConfig> sourceConfigList = new ArrayList<SourceConfig>(configList.size());
        for (ReadonlyConfig readonlyConfig : configList) {
            SourceConfig sourceConfig = this.parseOneIndexQueryConfig(readonlyConfig);
            sourceConfigList.add(sourceConfig);
        }
        return sourceConfigList;
    }

    private SourceConfig parseOneIndexQueryConfig(ReadonlyConfig readonlyConfig) {
        List<String> source;
        CatalogTable catalogTable;
        Map query = (Map)readonlyConfig.get(SourceConfig.QUERY);
        String index = (String)readonlyConfig.get(SourceConfig.INDEX);
        if (readonlyConfig.getOptional(TableSchemaOptions.SCHEMA).isPresent()) {
            log.warn("The schema config in ElasticSearch source/sink is deprecated, please use source config instead!");
            catalogTable = CatalogTableUtil.buildWithConfig((ReadonlyConfig)readonlyConfig);
            source = Arrays.asList(catalogTable.getSeaTunnelRowType().getFieldNames());
        } else {
            source = (List<String>)readonlyConfig.get(SourceConfig.SOURCE);
            Map arrayColumn = (Map)readonlyConfig.get(SourceConfig.ARRAY_COLUMN);
            Map<String, BasicTypeDefine<EsType>> esFieldType = this.getFieldTypeMapping(index, source);
            if (CollectionUtils.isEmpty(source)) {
                source = new ArrayList<String>(esFieldType.keySet());
            }
            SeaTunnelDataType[] fieldTypes = ElasticsearchSource.getSeaTunnelDataType(esFieldType, source);
            TableSchema.Builder builder = TableSchema.builder();
            for (int i = 0; i < source.size(); ++i) {
                String key = source.get(i);
                String sourceType = esFieldType.get(key).getDataType();
                if (arrayColumn.containsKey(key)) {
                    String value = (String)arrayColumn.get(key);
                    SeaTunnelDataType dataType = SeaTunnelDataTypeConvertorUtil.deserializeSeaTunnelDataType((String)key, (String)value);
                    builder.column((Column)PhysicalColumn.of((String)key, (SeaTunnelDataType)dataType, (Long)0L, (boolean)true, null, null, (String)sourceType, null));
                    continue;
                }
                builder.column((Column)PhysicalColumn.of((String)source.get(i), (SeaTunnelDataType)fieldTypes[i], (Long)0L, (boolean)true, null, null, (String)sourceType, null));
            }
            catalogTable = CatalogTable.of((TableIdentifier)TableIdentifier.of((String)"elasticsearch", null, (String)index), (TableSchema)builder.build(), Collections.emptyMap(), Collections.emptyList(), (String)"");
        }
        String scrollTime = (String)readonlyConfig.get(SourceConfig.SCROLL_TIME);
        int scrollSize = (Integer)readonlyConfig.get(SourceConfig.SCROLL_SIZE);
        SourceConfig sourceConfig = new SourceConfig();
        sourceConfig.setSource(source);
        sourceConfig.setCatalogTable(catalogTable);
        sourceConfig.setQuery(query);
        sourceConfig.setScrollTime(scrollTime);
        sourceConfig.setScrollSize(scrollSize);
        sourceConfig.setIndex(index);
        sourceConfig.setCatalogTable(catalogTable);
        return sourceConfig;
    }

    public String getPluginName() {
        return "Elasticsearch";
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return this.sourceConfigList.stream().map(SourceConfig::getCatalogTable).collect(Collectors.toList());
    }

    public SourceReader<SeaTunnelRow, ElasticsearchSourceSplit> createReader(SourceReader.Context readerContext) {
        return new ElasticsearchSourceReader(readerContext, this.connectionConfig);
    }

    public SourceSplitEnumerator<ElasticsearchSourceSplit, ElasticsearchSourceState> createEnumerator(SourceSplitEnumerator.Context<ElasticsearchSourceSplit> enumeratorContext) {
        return new ElasticsearchSourceSplitEnumerator(enumeratorContext, this.connectionConfig, this.sourceConfigList);
    }

    public SourceSplitEnumerator<ElasticsearchSourceSplit, ElasticsearchSourceState> restoreEnumerator(SourceSplitEnumerator.Context<ElasticsearchSourceSplit> enumeratorContext, ElasticsearchSourceState sourceState) {
        return new ElasticsearchSourceSplitEnumerator(enumeratorContext, sourceState, this.connectionConfig, this.sourceConfigList);
    }

    @VisibleForTesting
    public static SeaTunnelDataType[] getSeaTunnelDataType(Map<String, BasicTypeDefine<EsType>> esFieldType, List<String> source) {
        SeaTunnelDataType[] fieldTypes = new SeaTunnelDataType[source.size()];
        for (int i = 0; i < source.size(); ++i) {
            SeaTunnelDataType seaTunnelDataType;
            BasicTypeDefine<EsType> esType = esFieldType.get(source.get(i));
            fieldTypes[i] = seaTunnelDataType = ElasticSearchTypeConverter.INSTANCE.convert(esType).getDataType();
        }
        return fieldTypes;
    }

    private Map<String, BasicTypeDefine<EsType>> getFieldTypeMapping(String index, List<String> source) {
        try (EsRestClient esRestClient = EsRestClient.createInstance(this.connectionConfig);){
            Map<String, BasicTypeDefine<EsType>> map = esRestClient.getFieldTypeMapping(index, source);
            return map;
        }
    }
}

