/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.EsRestClient;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.SourceConfig;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.dto.source.IndexDocsCount;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.exception.ElasticsearchConnectorException;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.source.ElasticsearchSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.source.ElasticsearchSourceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchSourceSplitEnumerator
implements SourceSplitEnumerator<ElasticsearchSourceSplit, ElasticsearchSourceState> {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchSourceSplitEnumerator.class);
    private final SourceSplitEnumerator.Context<ElasticsearchSourceSplit> context;
    private final ReadonlyConfig connConfig;
    private EsRestClient esRestClient;
    private final Object stateLock = new Object();
    private Map<Integer, List<ElasticsearchSourceSplit>> pendingSplit;
    private final List<SourceConfig> sourceConfigs;
    private volatile boolean shouldEnumerate;

    public ElasticsearchSourceSplitEnumerator(SourceSplitEnumerator.Context<ElasticsearchSourceSplit> context, ReadonlyConfig connConfig, List<SourceConfig> sourceConfigs) {
        this(context, null, connConfig, sourceConfigs);
    }

    public ElasticsearchSourceSplitEnumerator(SourceSplitEnumerator.Context<ElasticsearchSourceSplit> context, ElasticsearchSourceState sourceState, ReadonlyConfig connConfig, List<SourceConfig> sourceConfigs) {
        this.context = context;
        this.connConfig = connConfig;
        this.pendingSplit = new HashMap<Integer, List<ElasticsearchSourceSplit>>();
        boolean bl = this.shouldEnumerate = sourceState == null;
        if (sourceState != null) {
            this.shouldEnumerate = sourceState.isShouldEnumerate();
            this.pendingSplit.putAll(sourceState.getPendingSplit());
        }
        this.sourceConfigs = sourceConfigs;
    }

    public void open() {
        this.esRestClient = EsRestClient.createInstance(this.connConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Set readers = this.context.registeredReaders();
        if (this.shouldEnumerate) {
            List<ElasticsearchSourceSplit> newSplits = this.getElasticsearchSplit();
            Object object = this.stateLock;
            synchronized (object) {
                this.addPendingSplit(newSplits);
                this.shouldEnumerate = false;
            }
            this.assignSplit(readers);
        }
        log.debug("No more splits to assign. Sending NoMoreSplitsEvent to reader {}.", (Object)readers);
        readers.forEach(arg_0 -> this.context.signalNoMoreSplits(arg_0));
    }

    private void addPendingSplit(Collection<ElasticsearchSourceSplit> splits) {
        int readerCount = this.context.currentParallelism();
        for (ElasticsearchSourceSplit split : splits) {
            int ownerReader = ElasticsearchSourceSplitEnumerator.getSplitOwner(split.splitId(), readerCount);
            log.info("Assigning {} to {} reader.", (Object)split, (Object)ownerReader);
            this.pendingSplit.computeIfAbsent(ownerReader, r -> new ArrayList()).add(split);
        }
    }

    private static int getSplitOwner(String tp, int numReaders) {
        return (tp.hashCode() & Integer.MAX_VALUE) % numReaders;
    }

    private void assignSplit(Collection<Integer> readers) {
        log.debug("Assign pendingSplits to readers {}", readers);
        for (int reader : readers) {
            List<ElasticsearchSourceSplit> assignmentForReader = this.pendingSplit.remove(reader);
            if (assignmentForReader == null || assignmentForReader.isEmpty()) continue;
            log.info("Assign splits {} to reader {}", assignmentForReader, (Object)reader);
            try {
                this.context.assignSplit(reader, assignmentForReader);
            }
            catch (Exception e) {
                log.error("Failed to assign splits {} to reader {}", new Object[]{assignmentForReader, reader, e});
                this.pendingSplit.put(reader, assignmentForReader);
            }
        }
    }

    private List<ElasticsearchSourceSplit> getElasticsearchSplit() {
        ArrayList<ElasticsearchSourceSplit> splits = new ArrayList<ElasticsearchSourceSplit>();
        for (SourceConfig sourceConfig : this.sourceConfigs) {
            String index = sourceConfig.getIndex();
            List<IndexDocsCount> indexDocsCounts = this.esRestClient.getIndexDocsCount(index);
            indexDocsCounts = indexDocsCounts.stream().filter(x -> x.getDocsCount() != null && x.getDocsCount() > 0L).sorted(Comparator.comparingLong(IndexDocsCount::getDocsCount)).collect(Collectors.toList());
            for (IndexDocsCount indexDocsCount : indexDocsCounts) {
                SourceConfig cloneCfg = sourceConfig.clone();
                cloneCfg.setIndex(indexDocsCount.getIndex());
                splits.add(new ElasticsearchSourceSplit(String.valueOf(indexDocsCount.getIndex().hashCode()), cloneCfg));
            }
        }
        return splits;
    }

    public void close() throws IOException {
        this.esRestClient.close();
    }

    public void addSplitsBack(List<ElasticsearchSourceSplit> splits, int subtaskId) {
        if (!splits.isEmpty()) {
            this.addPendingSplit(splits);
            this.assignSplit(Collections.singletonList(subtaskId));
        }
    }

    public int currentUnassignedSplitSize() {
        return this.pendingSplit.size();
    }

    public void handleSplitRequest(int subtaskId) {
        throw new ElasticsearchConnectorException((SeaTunnelErrorCode)CommonErrorCode.OPERATION_NOT_SUPPORTED, "Unsupported handleSplitRequest: " + subtaskId);
    }

    public void registerReader(int subtaskId) {
        log.debug("Register reader {} to IoTDBSourceSplitEnumerator.", (Object)subtaskId);
        if (!this.pendingSplit.isEmpty()) {
            this.assignSplit(Collections.singletonList(subtaskId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElasticsearchSourceState snapshotState(long checkpointId) throws Exception {
        Object object = this.stateLock;
        synchronized (object) {
            return new ElasticsearchSourceState(this.shouldEnumerate, this.pendingSplit);
        }
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
    }
}

