/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.email.sink;

import com.sun.mail.util.MailSSLSocketFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.email.config.EmailSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.email.exception.EmailConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.email.exception.EmailConnectorException;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailSinkWriter
extends AbstractSinkWriter<SeaTunnelRow, Void> {
    private static final Logger log = LoggerFactory.getLogger(EmailSinkWriter.class);
    private final SeaTunnelRowType seaTunnelRowType;
    private EmailSinkConfig config;
    private StringBuffer stringBuffer;

    public EmailSinkWriter(SeaTunnelRowType seaTunnelRowType, Config pluginConfig) {
        this.seaTunnelRowType = seaTunnelRowType;
        this.config = new EmailSinkConfig(pluginConfig);
        this.stringBuffer = new StringBuffer();
    }

    public void write(SeaTunnelRow element) {
        Object[] fields;
        for (Object field : fields = element.getFields()) {
            this.stringBuffer.append(field.toString() + ",");
        }
        this.stringBuffer.deleteCharAt(fields.length - 1);
        this.stringBuffer.append("\n");
    }

    public void close() {
        this.createFile();
        Properties properties = new Properties();
        properties.setProperty("mail.host", this.config.getEmailHost());
        properties.setProperty("mail.transport.protocol", this.config.getEmailTransportProtocol());
        properties.setProperty("mail.smtp.auth", this.config.getEmailSmtpAuth());
        try {
            MailSSLSocketFactory sf = new MailSSLSocketFactory();
            sf.setTrustAllHosts(true);
            properties.put("mail.smtp.ssl.enable", "true");
            properties.put("mail.smtp.ssl.socketFactory", sf);
            Session session = Session.getDefaultInstance(properties, new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(EmailSinkWriter.this.config.getEmailFromAddress(), EmailSinkWriter.this.config.getEmailAuthorizationCode());
                }
            });
            MimeMessage message = new MimeMessage(session);
            message.setFrom(new InternetAddress(this.config.getEmailFromAddress()));
            message.addRecipient(Message.RecipientType.TO, new InternetAddress(this.config.getEmailToAddress()));
            message.setSubject(this.config.getEmailMessageHeadline());
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setText(this.config.getEmailMessageContent());
            MimeMultipart multipart = new MimeMultipart();
            ((Multipart)multipart).addBodyPart(messageBodyPart);
            messageBodyPart = new MimeBodyPart();
            String filename = "emailsink.csv";
            FileDataSource source = new FileDataSource(filename);
            messageBodyPart.setDataHandler(new DataHandler(source));
            messageBodyPart.setFileName(filename);
            ((Multipart)multipart).addBodyPart(messageBodyPart);
            message.setContent(multipart);
            Transport.send(message);
            log.info("Sent message successfully....");
        }
        catch (Exception e) {
            throw new EmailConnectorException(EmailConnectorErrorCode.SEND_EMAIL_FAILED, "Send email failed", e);
        }
    }

    public void createFile() {
        try {
            String data = this.stringBuffer.toString();
            File file = new File("emailsink.csv");
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fileWriter = new FileWriter(file.getName());
            fileWriter.write(data);
            fileWriter.close();
            log.info("Create File successfully....");
        }
        catch (IOException e) {
            throw new EmailConnectorException((SeaTunnelErrorCode)CommonErrorCode.FILE_OPERATION_FAILED, "Create file failed", e);
        }
    }
}

