/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.ftp.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.options.ConnectorCommonOptions;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseSourceConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileSystemType;
import org.apache.seatunnel.connectors.seatunnel.file.ftp.config.FtpConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.file.ftp.source.FtpFileSource;

@AutoService(value={Factory.class})
public class FtpFileSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return FileSystemType.FTP.getFileSystemPluginName();
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        return () -> new FtpFileSource(context.getOptions());
    }

    public OptionRule optionRule() {
        return OptionRule.builder().optional(new Option[]{FtpConfigOptions.FILE_PATH}).optional(new Option[]{FtpConfigOptions.FTP_HOST}).optional(new Option[]{FtpConfigOptions.FTP_PORT}).optional(new Option[]{FtpConfigOptions.FTP_USERNAME}).optional(new Option[]{FtpConfigOptions.FTP_PASSWORD}).optional(new Option[]{FtpConfigOptions.FILE_FORMAT_TYPE}).conditional(BaseSourceConfigOptions.FILE_FORMAT_TYPE, (Object)FileFormat.TEXT, new Option[]{BaseSourceConfigOptions.FIELD_DELIMITER}).conditional(BaseSourceConfigOptions.FILE_FORMAT_TYPE, (Object)FileFormat.XML, new Option[]{BaseSourceConfigOptions.XML_ROW_TAG, BaseSourceConfigOptions.XML_USE_ATTR_FORMAT}).conditional(BaseSourceConfigOptions.FILE_FORMAT_TYPE, Arrays.asList(FileFormat.TEXT, FileFormat.JSON, FileFormat.EXCEL, FileFormat.CSV, FileFormat.XML), new Option[]{ConnectorCommonOptions.SCHEMA}).optional(new Option[]{BaseSourceConfigOptions.PARSE_PARTITION_FROM_PATH}).optional(new Option[]{BaseSourceConfigOptions.DATE_FORMAT}).optional(new Option[]{BaseSourceConfigOptions.DATETIME_FORMAT}).optional(new Option[]{BaseSourceConfigOptions.TIME_FORMAT}).optional(new Option[]{BaseSourceConfigOptions.FILE_FILTER_PATTERN}).optional(new Option[]{BaseSourceConfigOptions.COMPRESS_CODEC}).optional(new Option[]{FtpConfigOptions.FTP_CONNECTION_MODE}).optional(new Option[]{BaseSourceConfigOptions.ARCHIVE_COMPRESS_CODEC}).optional(new Option[]{BaseSourceConfigOptions.NULL_FORMAT}).optional(new Option[]{BaseSourceConfigOptions.FILENAME_EXTENSION}).build();
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return FtpFileSource.class;
    }
}

