/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.ftp.system;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.ftp.FTPException;
import org.apache.hadoop.fs.ftp.FTPInputStream;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.Progressable;
import org.apache.seatunnel.connectors.seatunnel.file.ftp.config.FtpFileBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.file.ftp.system.FtpConnectionMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SeaTunnelFTPFileSystem
extends FileSystem {
    private static final Logger log = LoggerFactory.getLogger(SeaTunnelFTPFileSystem.class);
    public static final Log LOG = LogFactory.getLog(SeaTunnelFTPFileSystem.class);
    public static final int DEFAULT_BUFFER_SIZE = 0x100000;
    public static final int DEFAULT_BLOCK_SIZE = 4096;
    public static final String FS_FTP_USER_PREFIX = "fs.ftp.user.";
    public static final String FS_FTP_HOST = "fs.ftp.host";
    public static final String FS_FTP_HOST_PORT = "fs.ftp.host.port";
    public static final String FS_FTP_PASSWORD_PREFIX = "fs.ftp.password.";
    public static final String FS_FTP_CONNECTION_MODE = "fs.ftp.connection.mode";
    public static final String FS_FTP_REMOTE_VERIFICATION_ENABLED = "fs.ftp.remote.verification.enabled";
    public static final String E_SAME_DIRECTORY_ONLY = "only same directory renames are supported";
    private URI uri;

    public String getScheme() {
        return "ftp";
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        String host = uri.getHost();
        String string = host = host == null ? conf.get(FS_FTP_HOST, null) : host;
        if (host == null) {
            throw new IOException("Invalid host specified");
        }
        conf.set(FS_FTP_HOST, host);
        int port = uri.getPort();
        port = port == -1 ? 21 : port;
        conf.setInt(FS_FTP_HOST_PORT, port);
        String userAndPassword = uri.getUserInfo();
        if (userAndPassword == null) {
            String user = conf.get(FS_FTP_USER_PREFIX + host, null);
            String password = conf.get(FS_FTP_PASSWORD_PREFIX + host, null);
            if (user == null || password == null) {
                throw new IOException("Invalid user/password specified");
            }
            userAndPassword = user + ":" + password;
        }
        String[] userPasswdInfo = userAndPassword.split(":");
        conf.set(FS_FTP_USER_PREFIX + host, userPasswdInfo[0]);
        if (userPasswdInfo.length > 1) {
            conf.set(FS_FTP_PASSWORD_PREFIX + host, userPasswdInfo[1]);
        } else {
            conf.set(FS_FTP_PASSWORD_PREFIX + host, null);
        }
        this.setConf(conf);
        this.uri = uri;
    }

    private FTPClient connect() throws IOException {
        FTPClient client = new FTPClient();
        Configuration conf = this.getConf();
        String connectionMode = conf.get(FS_FTP_CONNECTION_MODE, FtpConnectionMode.ACTIVE_LOCAL.getMode());
        boolean remoteVerificationEnabled = conf.getBoolean(FS_FTP_REMOTE_VERIFICATION_ENABLED, ((Boolean)FtpFileBaseOptions.FTP_REMOTE_VERIFICATION_ENABLED.defaultValue()).booleanValue());
        client.setRemoteVerificationEnabled(remoteVerificationEnabled);
        String host = conf.get(FS_FTP_HOST);
        int port = conf.getInt(FS_FTP_HOST_PORT, 21);
        String user = conf.get(FS_FTP_USER_PREFIX + host);
        String password = conf.get(FS_FTP_PASSWORD_PREFIX + host);
        client.connect(host, port);
        int reply = client.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            throw NetUtils.wrapException((String)host, (int)port, (String)"(unknown)", (int)0, (IOException)new ConnectException("Server response " + reply));
        }
        if (!client.login(user, password)) {
            throw new IOException(String.format("Login failed on server - %s, port - %d as user '%s', reply code: %d", host, port, user, client.getReplyCode()));
        }
        client.setFileType(2);
        client.setBufferSize(0x100000);
        client.setFileTransferMode(11);
        this.setFsFtpConnectionMode(client, connectionMode);
        LOG.info((Object)String.format("Successfully connected to FTP server %s:%d in %s", host, port, connectionMode));
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFsFtpConnectionMode(FTPClient client, String mode) throws IOException {
        FtpConnectionMode connectionMode = FtpConnectionMode.fromMode(mode);
        switch (connectionMode) {
            case PASSIVE_LOCAL: {
                client.enterLocalPassiveMode();
                LOG.info((Object)"Using passive mode for FTP connection");
                break;
            }
            case ACTIVE_LOCAL: {
                String pathName = "/.ftptest" + System.currentTimeMillis();
                try {
                    client.enterLocalActiveMode();
                    boolean created = client.makeDirectory(pathName);
                    if (!created) {
                        LOG.warn((Object)"Active mode failed, switching to passive mode");
                        throw new IOException("FTP connection active mode test failed");
                    }
                    LOG.info((Object)"Using active mode for FTP connection");
                    break;
                }
                catch (IOException e) {
                    client.enterLocalPassiveMode();
                    this.getConf().set(FS_FTP_CONNECTION_MODE, FtpConnectionMode.PASSIVE_LOCAL.getMode());
                    break;
                }
                finally {
                    FTPFile[] files = client.listFiles(pathName);
                    if (files != null && files.length > 0) {
                        client.deleteFile(pathName);
                    }
                }
            }
            default: {
                log.warn("Unsupported FTP connection mode: " + mode, (Object)(" Using default FTP connection mode: " + FtpConnectionMode.ACTIVE_LOCAL.getMode()));
                client.enterLocalActiveMode();
            }
        }
    }

    private void disconnect(FTPClient client) throws IOException {
        if (client != null) {
            if (!client.isConnected()) {
                throw new FTPException("Client not connected");
            }
            boolean logoutSuccess = client.logout();
            client.disconnect();
            if (!logoutSuccess) {
                LOG.warn((Object)("Logout failed while disconnecting, error code - " + client.getReplyCode()));
            }
        }
    }

    private Path makeAbsolute(Path workDir, Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(workDir, path);
    }

    public FSDataInputStream open(Path file, int bufferSize) throws IOException {
        Path workDir;
        Path absolute;
        FTPClient client = this.connect();
        FileStatus fileStat = this.getFileStatus(client, absolute = this.makeAbsolute(workDir = new Path(client.printWorkingDirectory()), file));
        if (fileStat.isDirectory()) {
            this.disconnect(client);
            throw new FileNotFoundException("Path " + file + " is a directory.");
        }
        client.allocate(bufferSize);
        Path parent = absolute.getParent();
        client.changeWorkingDirectory(parent.toUri().getPath());
        InputStream is = client.retrieveFileStream(file.getName());
        FSDataInputStream fis = new FSDataInputStream((InputStream)new FTPInputStream(is, client, this.statistics));
        if (!FTPReply.isPositivePreliminary((int)client.getReplyCode())) {
            fis.close();
            throw new IOException("Unable to open file: " + file + ", Aborting");
        }
        return fis;
    }

    public FSDataOutputStream create(Path file, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path parent;
        FileStatus status;
        final FTPClient client = this.connect();
        Path workDir = new Path(client.printWorkingDirectory());
        Path absolute = this.makeAbsolute(workDir, file);
        try {
            status = this.getFileStatus(client, file);
        }
        catch (FileNotFoundException fnfe) {
            status = null;
        }
        if (status != null) {
            if (overwrite && !status.isDirectory()) {
                this.delete(client, file, false);
            } else {
                this.disconnect(client);
                throw new FileAlreadyExistsException("File already exists: " + file);
            }
        }
        if ((parent = absolute.getParent()) == null || !this.mkdirs(client, parent, FsPermission.getDirDefault())) {
            parent = parent == null ? new Path("/") : parent;
            this.disconnect(client);
            throw new IOException("create(): Mkdirs failed to create: " + parent);
        }
        client.allocate(bufferSize);
        client.changeWorkingDirectory(parent.toUri().getPath());
        FSDataOutputStream fos = new FSDataOutputStream(client.storeFileStream(file.getName()), this.statistics){

            public void close() throws IOException {
                super.close();
                if (!client.isConnected()) {
                    throw new FTPException("Client not connected");
                }
                boolean cmdCompleted = client.completePendingCommand();
                SeaTunnelFTPFileSystem.this.disconnect(client);
                if (!cmdCompleted) {
                    throw new FTPException("Could not complete transfer, Reply Code - " + client.getReplyCode());
                }
            }
        };
        if (!FTPReply.isPositivePreliminary((int)client.getReplyCode())) {
            fos.close();
            throw new IOException("Unable to create file: " + file + ", Aborting");
        }
        return fos;
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    private boolean exists(FTPClient client, Path file) throws IOException {
        try {
            return this.getFileStatus(client, file) != null;
        }
        catch (FileNotFoundException fnfe) {
            LOG.debug((Object)("File does not exist: " + file), (Throwable)fnfe);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Path file, boolean recursive) throws IOException {
        FTPClient client = this.connect();
        try {
            boolean success;
            boolean bl = success = this.delete(client, file, recursive);
            return bl;
        }
        finally {
            this.disconnect(client);
        }
    }

    private boolean delete(FTPClient client, Path file, boolean recursive) throws IOException {
        Path workDir = new Path(client.printWorkingDirectory());
        Path absolute = this.makeAbsolute(workDir, file);
        String pathName = absolute.toUri().getPath();
        try {
            FileStatus fileStat = this.getFileStatus(client, absolute);
            if (fileStat.isFile()) {
                return client.deleteFile(pathName);
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        FileStatus[] dirEntries = this.listStatus(client, absolute);
        if (dirEntries != null && dirEntries.length > 0 && !recursive) {
            throw new IOException("Directory: " + file + " is not empty.");
        }
        if (dirEntries != null) {
            for (int i = 0; i < dirEntries.length; ++i) {
                this.delete(client, new Path(absolute, dirEntries[i].getPath()), recursive);
            }
        }
        return client.removeDirectory(pathName);
    }

    private FsAction getFsAction(int accessGroup, FTPFile ftpFile) {
        FsAction action = FsAction.NONE;
        if (ftpFile.hasPermission(accessGroup, 0)) {
            action.or(FsAction.READ);
        }
        if (ftpFile.hasPermission(accessGroup, 1)) {
            action.or(FsAction.WRITE);
        }
        if (ftpFile.hasPermission(accessGroup, 2)) {
            action.or(FsAction.EXECUTE);
        }
        return action;
    }

    private FsPermission getPermissions(FTPFile ftpFile) {
        FsAction user = this.getFsAction(0, ftpFile);
        FsAction group = this.getFsAction(1, ftpFile);
        FsAction others = this.getFsAction(2, ftpFile);
        return new FsPermission(user, group, others);
    }

    public URI getUri() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStatus[] listStatus(Path file) throws IOException {
        FTPClient client = this.connect();
        try {
            FileStatus[] stats;
            FileStatus[] fileStatusArray = stats = this.listStatus(client, file);
            return fileStatusArray;
        }
        finally {
            this.disconnect(client);
        }
    }

    private FileStatus[] listStatus(FTPClient client, Path file) throws IOException {
        Path workDir = new Path(client.printWorkingDirectory());
        Path absolute = this.makeAbsolute(workDir, file);
        FileStatus fileStat = this.getFileStatus(client, absolute);
        if (fileStat.isFile()) {
            return new FileStatus[]{fileStat};
        }
        FTPFile[] ftpFiles = client.listFiles(absolute.toUri().getPath());
        FileStatus[] fileStats = new FileStatus[ftpFiles.length];
        for (int i = 0; i < ftpFiles.length; ++i) {
            fileStats[i] = this.getFileStatus(ftpFiles[i], absolute);
        }
        return fileStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStatus getFileStatus(Path file) throws IOException {
        FTPClient client = this.connect();
        try {
            FileStatus status;
            FileStatus fileStatus = status = this.getFileStatus(client, file);
            return fileStatus;
        }
        finally {
            this.disconnect(client);
        }
    }

    private FileStatus getFileStatus(FTPClient client, Path file) throws IOException {
        FileStatus fileStat = null;
        Path workDir = new Path(client.printWorkingDirectory());
        Path absolute = this.makeAbsolute(workDir, file);
        Path parentPath = absolute.getParent();
        if (parentPath == null) {
            long length = -1L;
            boolean isDir = true;
            int blockReplication = 1;
            long blockSize = 4096L;
            long modTime = -1L;
            Path root = new Path("/");
            return new FileStatus(length, isDir, blockReplication, blockSize, modTime, root.makeQualified((FileSystem)this));
        }
        String pathName = parentPath.toUri().getPath();
        FTPFile[] ftpFiles = client.listFiles(pathName);
        if (ftpFiles != null) {
            for (FTPFile ftpFile : ftpFiles) {
                if (!ftpFile.getName().equals(file.getName())) continue;
                fileStat = this.getFileStatus(ftpFile, parentPath);
                break;
            }
            if (fileStat == null) {
                throw new FileNotFoundException("File " + file + " does not exist.");
            }
        } else {
            throw new FileNotFoundException("File " + file + " does not exist.");
        }
        return fileStat;
    }

    private FileStatus getFileStatus(FTPFile ftpFile, Path parentPath) {
        long length = ftpFile.getSize();
        boolean isDir = ftpFile.isDirectory();
        int blockReplication = 1;
        long blockSize = 4096L;
        long modTime = ftpFile.getTimestamp().getTimeInMillis();
        long accessTime = 0L;
        FsPermission permission = this.getPermissions(ftpFile);
        String user = ftpFile.getUser();
        String group = ftpFile.getGroup();
        Path filePath = new Path(parentPath, ftpFile.getName());
        return new FileStatus(length, isDir, blockReplication, blockSize, modTime, accessTime, permission, user, group, filePath.makeQualified((FileSystem)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mkdirs(Path file, FsPermission permission) throws IOException {
        FTPClient client = this.connect();
        try {
            boolean success;
            boolean bl = success = this.mkdirs(client, file, permission);
            return bl;
        }
        finally {
            this.disconnect(client);
        }
    }

    private boolean mkdirs(FTPClient client, Path file, FsPermission permission) throws IOException {
        String parentDir;
        Path workDir = new Path(client.printWorkingDirectory());
        Path absolute = this.makeAbsolute(workDir, file);
        if (this.exists(client, absolute)) {
            if (this.isFile(client, absolute)) {
                throw new ParentNotDirectoryException(String.format("Can't make directory for path %s since it is a file.", absolute));
            }
            return true;
        }
        Path parent = absolute.getParent();
        if (parent != null && !this.exists(client, parent)) {
            this.mkdirs(client, parent, FsPermission.getDirDefault());
        }
        String pathName = absolute.getName();
        String string = parentDir = parent != null ? parent.toUri().getPath() : "/";
        if (!client.changeWorkingDirectory(parentDir)) {
            throw new IOException(String.format("Failed to change working directory to %s, FTP reply code: %d, reply string: %s", parentDir, client.getReplyCode(), client.getReplyString()));
        }
        boolean created = client.makeDirectory(pathName);
        if (!created && !this.exists(client, absolute)) {
            throw new IOException(String.format("Failed to create directory %s in %s, FTP reply code: %d, reply string: %s", pathName, parentDir, client.getReplyCode(), client.getReplyString()));
        }
        return true;
    }

    private boolean isFile(FTPClient client, Path file) {
        try {
            return this.getFileStatus(client, file).isFile();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException ioe) {
            throw new FTPException("File check failed", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(Path src, Path dst) throws IOException {
        FTPClient client = this.connect();
        try {
            boolean success;
            boolean bl = success = this.rename(client, src, dst);
            return bl;
        }
        finally {
            this.disconnect(client);
        }
    }

    private boolean isParentOf(Path parent, Path child) {
        URI parentURI = parent.toUri();
        String parentPath = parentURI.getPath();
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        URI childURI = child.toUri();
        String childPath = childURI.getPath();
        return childPath.startsWith(parentPath);
    }

    private boolean rename(FTPClient client, Path src, Path dst) throws IOException {
        Path workDir = new Path(client.printWorkingDirectory());
        Path absoluteSrc = this.makeAbsolute(workDir, src);
        Path absoluteDst = this.makeAbsolute(workDir, dst);
        if (!this.exists(client, absoluteSrc)) {
            throw new FileNotFoundException("Source path " + src + " does not exist");
        }
        if (this.isDirectory(absoluteDst)) {
            absoluteDst = new Path(absoluteDst, absoluteSrc.getName());
        }
        if (this.exists(client, absoluteDst)) {
            throw new FileAlreadyExistsException("Destination path " + dst + " already exists");
        }
        if (this.isParentOf(absoluteSrc, absoluteDst)) {
            throw new IOException("Cannot rename " + absoluteSrc + " under itself : " + absoluteDst);
        }
        String from = absoluteSrc.toString();
        String to = absoluteDst.toString();
        return client.rename(from, to);
    }

    public Path getWorkingDirectory() {
        return this.getHomeDirectory();
    }

    public Path getHomeDirectory() {
        FTPClient client = null;
        try {
            Path homeDir;
            client = this.connect();
            Path path = homeDir = new Path(client.printWorkingDirectory());
            return path;
        }
        catch (IOException ioe) {
            throw new FTPException("Failed to get home directory", (Throwable)ioe);
        }
        finally {
            try {
                this.disconnect(client);
            }
            catch (IOException ioe) {
                throw new FTPException("Failed to disconnect", (Throwable)ioe);
            }
        }
    }

    public void setWorkingDirectory(Path newDir) {
    }
}

