/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.ftp.source;

import com.google.auto.service.AutoService;
import java.io.IOException;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileSystemType;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.ftp.config.FtpConf;
import org.apache.seatunnel.connectors.seatunnel.file.ftp.config.FtpConfig;
import org.apache.seatunnel.connectors.seatunnel.file.source.BaseFileSource;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.ReadStrategyFactory;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={SeaTunnelSource.class})
public class FtpFileSource
extends BaseFileSource {
    public String getPluginName() {
        return FileSystemType.FTP.getFileSystemPluginName();
    }

    public void prepare(Config pluginConfig) throws PrepareFailException {
        block11: {
            block10: {
                CheckResult result = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{FtpConfig.FILE_PATH.key(), FtpConfig.FILE_FORMAT_TYPE.key(), FtpConfig.FTP_HOST.key(), FtpConfig.FTP_PORT.key(), FtpConfig.FTP_USERNAME.key(), FtpConfig.FTP_PASSWORD.key()});
                if (!result.isSuccess()) {
                    throw new FileConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", this.getPluginName(), PluginType.SOURCE, result.getMsg()));
                }
                FileFormat fileFormat = FileFormat.valueOf(pluginConfig.getString(FtpConfig.FILE_FORMAT_TYPE.key()).toUpperCase());
                if (fileFormat == FileFormat.ORC || fileFormat == FileFormat.PARQUET) {
                    throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.ILLEGAL_ARGUMENT, "Ftp file source connector only support read [text, csv, json] files");
                }
                this.readStrategy = ReadStrategyFactory.of(pluginConfig.getString(FtpConfig.FILE_FORMAT_TYPE.key()));
                this.readStrategy.setPluginConfig(pluginConfig);
                String path = pluginConfig.getString(FtpConfig.FILE_PATH.key());
                this.hadoopConf = FtpConf.buildWithConfig(pluginConfig);
                try {
                    this.filePaths = this.readStrategy.getFileNamesByPath(this.hadoopConf, path);
                }
                catch (IOException e) {
                    String errorMsg = String.format("Get file list from this path [%s] failed", path);
                    throw new FileConnectorException(FileConnectorErrorCode.FILE_LIST_GET_FAILED, errorMsg, e);
                }
                if (!pluginConfig.hasPath(CatalogTableUtil.SCHEMA.key())) break block10;
                switch (fileFormat) {
                    case CSV: 
                    case TEXT: 
                    case JSON: 
                    case EXCEL: {
                        SeaTunnelRowType userDefinedSchema = CatalogTableUtil.buildWithConfig((Config)pluginConfig).getSeaTunnelRowType();
                        this.readStrategy.setSeaTunnelRowTypeInfo(userDefinedSchema);
                        this.rowType = this.readStrategy.getActualSeaTunnelRowTypeInfo();
                        break block11;
                    }
                    case ORC: 
                    case PARQUET: {
                        throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, "SeaTunnel does not support user-defined schema for [parquet, orc] files");
                    }
                    default: {
                        throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.ILLEGAL_ARGUMENT, "SeaTunnel does not supported this file format");
                    }
                }
            }
            try {
                this.rowType = this.readStrategy.getSeaTunnelRowTypeInfo(this.hadoopConf, (String)this.filePaths.get(0));
            }
            catch (FileConnectorException e) {
                String errorMsg = String.format("Get table schema from file [%s] failed", this.filePaths.get(0));
                throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.TABLE_SCHEMA_GET_FAILED, errorMsg, (Throwable)((Object)e));
            }
        }
    }
}

