/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.sink.writer;

import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.sink.config.FileSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.file.sink.writer.WriteStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(WriteStrategyFactory.class);

    private WriteStrategyFactory() {
    }

    public static WriteStrategy of(String fileType, FileSinkConfig fileSinkConfig) {
        try {
            FileFormat fileFormat = FileFormat.valueOf(fileType.toUpperCase());
            return fileFormat.getWriteStrategy(fileSinkConfig);
        }
        catch (IllegalArgumentException e) {
            String errorMsg = String.format("File sink connector not support this file type [%s], please check your config", fileType);
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.ILLEGAL_ARGUMENT, errorMsg);
        }
    }

    public static WriteStrategy of(FileFormat fileFormat, FileSinkConfig fileSinkConfig) {
        return fileFormat.getWriteStrategy(fileSinkConfig);
    }
}

