/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.file.org.apache.parquet.internal.column.columnindex;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.IntPredicate;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.column.MinMax;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.filter2.predicate.Operators;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.filter2.predicate.Statistics;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.internal.column.columnindex.BinaryColumnIndexBuilder;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.internal.column.columnindex.BooleanColumnIndexBuilder;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.internal.column.columnindex.BoundaryOrder;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.internal.column.columnindex.DoubleColumnIndexBuilder;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.internal.column.columnindex.FloatColumnIndexBuilder;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.internal.column.columnindex.IndexIterator;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.internal.column.columnindex.IntColumnIndexBuilder;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.internal.column.columnindex.LongColumnIndexBuilder;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.io.api.Binary;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.schema.PrimitiveComparator;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.schema.PrimitiveStringifier;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.schema.PrimitiveType;
import org.apache.seatunnel.shade.connector.file.shaded.parquet.it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import org.apache.seatunnel.shade.connector.file.shaded.parquet.it.unimi.dsi.fastutil.booleans.BooleanList;
import org.apache.seatunnel.shade.connector.file.shaded.parquet.it.unimi.dsi.fastutil.booleans.BooleanLists;
import org.apache.seatunnel.shade.connector.file.shaded.parquet.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.apache.seatunnel.shade.connector.file.shaded.parquet.it.unimi.dsi.fastutil.ints.IntList;
import org.apache.seatunnel.shade.connector.file.shaded.parquet.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.apache.seatunnel.shade.connector.file.shaded.parquet.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.apache.seatunnel.shade.connector.file.shaded.parquet.it.unimi.dsi.fastutil.longs.LongList;
import org.apache.seatunnel.shade.connector.file.shaded.parquet.it.unimi.dsi.fastutil.longs.LongLists;

public abstract class ColumnIndexBuilder {
    private static final ColumnIndexBuilder NO_OP_BUILDER = new ColumnIndexBuilder(){

        @Override
        public ColumnIndex build() {
            return null;
        }

        @Override
        public void add(org.apache.seatunnel.shade.connector.file.org.apache.parquet.column.statistics.Statistics<?> stats) {
        }

        @Override
        void addMinMax(Object min, Object max) {
        }

        @Override
        ColumnIndexBase<?> createColumnIndex(PrimitiveType type) {
            return null;
        }

        @Override
        void clearMinMax() {
        }

        @Override
        void addMinMaxFromBytes(ByteBuffer min, ByteBuffer max) {
        }

        @Override
        int compareMinValues(PrimitiveComparator<Binary> comparator, int index1, int index2) {
            return 0;
        }

        @Override
        int compareMaxValues(PrimitiveComparator<Binary> comparator, int index1, int index2) {
            return 0;
        }

        @Override
        int sizeOf(Object value) {
            return 0;
        }
    };
    private PrimitiveType type;
    private final BooleanList nullPages = new BooleanArrayList();
    private final LongList nullCounts = new LongArrayList();
    private long minMaxSize;
    private final IntList pageIndexes = new IntArrayList();
    private int nextPageIndex;

    public static ColumnIndexBuilder getNoOpBuilder() {
        return NO_OP_BUILDER;
    }

    public static ColumnIndexBuilder getBuilder(PrimitiveType type, int truncateLength) {
        ColumnIndexBuilder builder = ColumnIndexBuilder.createNewBuilder(type, truncateLength);
        builder.type = type;
        return builder;
    }

    private static ColumnIndexBuilder createNewBuilder(PrimitiveType type, int truncateLength) {
        switch (type.getPrimitiveTypeName()) {
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: 
            case INT96: {
                return new BinaryColumnIndexBuilder(type, truncateLength);
            }
            case BOOLEAN: {
                return new BooleanColumnIndexBuilder();
            }
            case DOUBLE: {
                return new DoubleColumnIndexBuilder();
            }
            case FLOAT: {
                return new FloatColumnIndexBuilder();
            }
            case INT32: {
                return new IntColumnIndexBuilder();
            }
            case INT64: {
                return new LongColumnIndexBuilder();
            }
        }
        throw new IllegalArgumentException("Unsupported type for column index: " + type);
    }

    public static ColumnIndex build(PrimitiveType type, BoundaryOrder boundaryOrder, List<Boolean> nullPages, List<Long> nullCounts, List<ByteBuffer> minValues, List<ByteBuffer> maxValues) {
        ColumnIndexBuilder builder = ColumnIndexBuilder.createNewBuilder(type, Integer.MAX_VALUE);
        builder.fill(nullPages, nullCounts, minValues, maxValues);
        ColumnIndexBase<?> columnIndex = builder.build(type);
        ((ColumnIndexBase)columnIndex).boundaryOrder = Objects.requireNonNull(boundaryOrder);
        return columnIndex;
    }

    ColumnIndexBuilder() {
    }

    public void add(org.apache.seatunnel.shade.connector.file.org.apache.parquet.column.statistics.Statistics<?> stats) {
        if (stats.hasNonNullValue()) {
            this.nullPages.add(false);
            Object min = stats.genericGetMin();
            Object max = stats.genericGetMax();
            this.addMinMax(min, max);
            this.pageIndexes.add(this.nextPageIndex);
            this.minMaxSize += (long)this.sizeOf(min);
            this.minMaxSize += (long)this.sizeOf(max);
        } else {
            this.nullPages.add(true);
        }
        this.nullCounts.add(stats.getNumNulls());
        ++this.nextPageIndex;
    }

    abstract void addMinMaxFromBytes(ByteBuffer var1, ByteBuffer var2);

    abstract void addMinMax(Object var1, Object var2);

    private void fill(List<Boolean> nullPages, List<Long> nullCounts, List<ByteBuffer> minValues, List<ByteBuffer> maxValues) {
        this.clear();
        int pageCount = nullPages.size();
        if (nullCounts != null && nullCounts.size() != pageCount || minValues.size() != pageCount || maxValues.size() != pageCount) {
            throw new IllegalArgumentException(String.format("Not all sizes are equal (nullPages:%d, nullCounts:%s, minValues:%d, maxValues:%d", nullPages.size(), nullCounts == null ? "null" : Integer.valueOf(nullCounts.size()), minValues.size(), maxValues.size()));
        }
        this.nullPages.addAll(nullPages);
        if (nullCounts != null) {
            this.nullCounts.addAll(nullCounts);
        }
        for (int i = 0; i < pageCount; ++i) {
            if (nullPages.get(i).booleanValue()) continue;
            ByteBuffer min = minValues.get(i);
            ByteBuffer max = maxValues.get(i);
            this.addMinMaxFromBytes(min, max);
            this.pageIndexes.add(i);
            this.minMaxSize += (long)min.remaining();
            this.minMaxSize += (long)max.remaining();
        }
    }

    public ColumnIndex build() {
        ColumnIndexBase<?> columnIndex = this.build(this.type);
        if (columnIndex == null) {
            return null;
        }
        ((ColumnIndexBase)columnIndex).boundaryOrder = this.calculateBoundaryOrder(this.type.comparator());
        return columnIndex;
    }

    private ColumnIndexBase<?> build(PrimitiveType type) {
        if (this.nullPages.isEmpty()) {
            return null;
        }
        ColumnIndexBase<?> columnIndex = this.createColumnIndex(type);
        if (columnIndex == null) {
            return null;
        }
        ColumnIndexBase.access$302(columnIndex, this.nullPages.toBooleanArray());
        if (!this.nullCounts.isEmpty()) {
            ColumnIndexBase.access$102(columnIndex, this.nullCounts.toLongArray());
        }
        ColumnIndexBase.access$002(columnIndex, this.pageIndexes.toIntArray());
        return columnIndex;
    }

    private BoundaryOrder calculateBoundaryOrder(PrimitiveComparator<Binary> comparator) {
        if (this.isAscending(comparator)) {
            return BoundaryOrder.ASCENDING;
        }
        if (this.isDescending(comparator)) {
            return BoundaryOrder.DESCENDING;
        }
        return BoundaryOrder.UNORDERED;
    }

    private boolean isAscending(PrimitiveComparator<Binary> comparator) {
        int n = this.pageIndexes.size();
        for (int i = 1; i < n; ++i) {
            if (this.compareMinValues(comparator, i - 1, i) <= 0 && this.compareMaxValues(comparator, i - 1, i) <= 0) continue;
            return false;
        }
        return true;
    }

    private boolean isDescending(PrimitiveComparator<Binary> comparator) {
        int n = this.pageIndexes.size();
        for (int i = 1; i < n; ++i) {
            if (this.compareMinValues(comparator, i - 1, i) >= 0 && this.compareMaxValues(comparator, i - 1, i) >= 0) continue;
            return false;
        }
        return true;
    }

    abstract int compareMinValues(PrimitiveComparator<Binary> var1, int var2, int var3);

    abstract int compareMaxValues(PrimitiveComparator<Binary> var1, int var2, int var3);

    private void clear() {
        this.nullPages.clear();
        this.nullCounts.clear();
        this.clearMinMax();
        this.minMaxSize = 0L;
        this.nextPageIndex = 0;
        this.pageIndexes.clear();
    }

    abstract void clearMinMax();

    abstract ColumnIndexBase<?> createColumnIndex(PrimitiveType var1);

    abstract int sizeOf(Object var1);

    public int getPageCount() {
        return this.nullPages.size();
    }

    public long getMinMaxSize() {
        return this.minMaxSize;
    }

    static abstract class ColumnIndexBase<C>
    implements ColumnIndex {
        private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
        private static final int MAX_VALUE_LENGTH_FOR_TOSTRING = 40;
        private static final String TOSTRING_TRUNCATION_MARKER = "(...)";
        private static final int TOSTRING_TRUNCATION_START_POS = (40 - "(...)".length()) / 2;
        private static final int TOSTRING_TRUNCATION_END_POS = 40 - "(...)".length() - TOSTRING_TRUNCATION_START_POS;
        private static final String TOSTRING_MISSING_VALUE_MARKER = "<none>";
        final PrimitiveStringifier stringifier;
        final PrimitiveComparator<C> comparator;
        private boolean[] nullPages;
        private BoundaryOrder boundaryOrder;
        private int[] pageIndexes;
        private long[] nullCounts;

        static String truncate(String str) {
            if (str.length() <= 40) {
                return str;
            }
            return str.substring(0, TOSTRING_TRUNCATION_START_POS) + TOSTRING_TRUNCATION_MARKER + str.substring(str.length() - TOSTRING_TRUNCATION_END_POS);
        }

        ColumnIndexBase(PrimitiveType type) {
            this.comparator = type.comparator();
            this.stringifier = type.stringifier();
        }

        @Override
        public BoundaryOrder getBoundaryOrder() {
            return this.boundaryOrder;
        }

        @Override
        public List<Long> getNullCounts() {
            if (this.nullCounts == null) {
                return null;
            }
            return LongLists.unmodifiable(LongArrayList.wrap(this.nullCounts));
        }

        @Override
        public List<Boolean> getNullPages() {
            return BooleanLists.unmodifiable(BooleanArrayList.wrap(this.nullPages));
        }

        @Override
        public List<ByteBuffer> getMinValues() {
            ArrayList<ByteBuffer> list = new ArrayList<ByteBuffer>(this.getPageCount());
            int arrayIndex = 0;
            int n = this.getPageCount();
            for (int i = 0; i < n; ++i) {
                if (this.isNullPage(i)) {
                    list.add(EMPTY_BYTE_BUFFER);
                    continue;
                }
                list.add(this.getMinValueAsBytes(arrayIndex++));
            }
            return list;
        }

        @Override
        public List<ByteBuffer> getMaxValues() {
            ArrayList<ByteBuffer> list = new ArrayList<ByteBuffer>(this.getPageCount());
            int arrayIndex = 0;
            int n = this.getPageCount();
            for (int i = 0; i < n; ++i) {
                if (this.isNullPage(i)) {
                    list.add(EMPTY_BYTE_BUFFER);
                    continue;
                }
                list.add(this.getMaxValueAsBytes(arrayIndex++));
            }
            return list;
        }

        public String toString() {
            try (Formatter formatter = new Formatter();){
                formatter.format("Boundary order: %s\n", new Object[]{this.boundaryOrder});
                String minMaxPart = "  %-40s  %-40s\n";
                formatter.format("%-10s  %20s" + minMaxPart, "", "null count", "min", "max");
                String format = "page-%-5d  %20s" + minMaxPart;
                int arrayIndex = 0;
                int n = this.nullPages.length;
                for (int i = 0; i < n; ++i) {
                    String min;
                    String max;
                    String nullCount;
                    String string = nullCount = this.nullCounts == null ? TOSTRING_MISSING_VALUE_MARKER : Long.toString(this.nullCounts[i]);
                    if (this.nullPages[i]) {
                        max = TOSTRING_MISSING_VALUE_MARKER;
                        min = TOSTRING_MISSING_VALUE_MARKER;
                    } else {
                        min = ColumnIndexBase.truncate(this.getMinValueAsString(arrayIndex));
                        max = ColumnIndexBase.truncate(this.getMaxValueAsString(arrayIndex++));
                    }
                    formatter.format(format, i, nullCount, min, max);
                }
                String string = formatter.toString();
                return string;
            }
        }

        int getPageCount() {
            return this.nullPages.length;
        }

        boolean isNullPage(int pageIndex) {
            return this.nullPages[pageIndex];
        }

        abstract ByteBuffer getMinValueAsBytes(int var1);

        abstract ByteBuffer getMaxValueAsBytes(int var1);

        abstract String getMinValueAsString(int var1);

        abstract String getMaxValueAsString(int var1);

        abstract <T extends Comparable<T>> Statistics<T> createStats(int var1);

        abstract ValueComparator createValueComparator(Object var1);

        @Override
        public PrimitiveIterator.OfInt visit(Operators.And and) {
            throw new UnsupportedOperationException("AND shall not be used on column index directly");
        }

        @Override
        public PrimitiveIterator.OfInt visit(Operators.Not not) {
            throw new UnsupportedOperationException("NOT shall not be used on column index directly");
        }

        @Override
        public PrimitiveIterator.OfInt visit(Operators.Or or) {
            throw new UnsupportedOperationException("OR shall not be used on column index directly");
        }

        @Override
        public <T extends Comparable<T>> PrimitiveIterator.OfInt visit(Operators.Eq<T> eq) {
            Comparable value = eq.getValue();
            if (value == null) {
                if (this.nullCounts == null) {
                    return IndexIterator.all(this.getPageCount());
                }
                return IndexIterator.filter(this.getPageCount(), pageIndex -> this.nullCounts[pageIndex] > 0L);
            }
            return this.getBoundaryOrder().eq(this.createValueComparator(value));
        }

        @Override
        public <T extends Comparable<T>> PrimitiveIterator.OfInt visit(Operators.Gt<T> gt) {
            return this.getBoundaryOrder().gt(this.createValueComparator(gt.getValue()));
        }

        @Override
        public <T extends Comparable<T>> PrimitiveIterator.OfInt visit(Operators.GtEq<T> gtEq) {
            return this.getBoundaryOrder().gtEq(this.createValueComparator(gtEq.getValue()));
        }

        @Override
        public <T extends Comparable<T>> PrimitiveIterator.OfInt visit(Operators.Lt<T> lt) {
            return this.getBoundaryOrder().lt(this.createValueComparator(lt.getValue()));
        }

        @Override
        public <T extends Comparable<T>> PrimitiveIterator.OfInt visit(Operators.LtEq<T> ltEq) {
            return this.getBoundaryOrder().ltEq(this.createValueComparator(ltEq.getValue()));
        }

        @Override
        public <T extends Comparable<T>> PrimitiveIterator.OfInt visit(Operators.NotEq<T> notEq) {
            Comparable value = notEq.getValue();
            if (value == null) {
                return IndexIterator.filter(this.getPageCount(), pageIndex -> !this.nullPages[pageIndex]);
            }
            if (this.nullCounts == null) {
                return IndexIterator.all(this.getPageCount());
            }
            IntOpenHashSet matchingIndexes = new IntOpenHashSet();
            this.getBoundaryOrder().notEq(this.createValueComparator(value)).forEachRemaining(index -> matchingIndexes.add(index));
            return IndexIterator.filter(this.getPageCount(), pageIndex -> this.nullCounts[pageIndex] > 0L || matchingIndexes.contains(pageIndex));
        }

        @Override
        public <T extends Comparable<T>> PrimitiveIterator.OfInt visit(Operators.In<T> in) {
            Set values = in.getValues();
            IntOpenHashSet matchingIndexesForNull = new IntOpenHashSet();
            for (Comparable value : values) {
                if (value != null) continue;
                if (this.nullCounts == null) {
                    return IndexIterator.all(this.getPageCount());
                }
                for (int i = 0; i < this.nullCounts.length; ++i) {
                    if (this.nullCounts[i] <= 0L) continue;
                    matchingIndexesForNull.add(i);
                }
                if (values.size() != 1) continue;
                return IndexIterator.filter(this.getPageCount(), pageIndex -> matchingIndexesForNull.contains(pageIndex));
            }
            IntOpenHashSet matchingIndexesLessThanMax = new IntOpenHashSet();
            IntOpenHashSet matchingIndexesGreaterThanMin = new IntOpenHashSet();
            MinMax<C> minMax = new MinMax<C>(this.comparator, values);
            Comparable min = (Comparable)minMax.getMin();
            Comparable max = (Comparable)minMax.getMax();
            this.getBoundaryOrder().ltEq(this.createValueComparator(max)).forEachRemaining(index -> matchingIndexesLessThanMax.add(index));
            this.getBoundaryOrder().gtEq(this.createValueComparator(min)).forEachRemaining(index -> matchingIndexesGreaterThanMin.add(index));
            matchingIndexesLessThanMax.retainAll(matchingIndexesGreaterThanMin);
            IntOpenHashSet matchingIndex = matchingIndexesLessThanMax;
            matchingIndex.addAll(matchingIndexesForNull);
            return IndexIterator.filter(this.getPageCount(), pageIndex -> matchingIndex.contains(pageIndex));
        }

        @Override
        public <T extends Comparable<T>> PrimitiveIterator.OfInt visit(Operators.NotIn<T> notIn) {
            return IndexIterator.all(this.getPageCount());
        }

        @Override
        public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> PrimitiveIterator.OfInt visit(Operators.UserDefined<T, U> udp) {
            U predicate = udp.getUserDefinedPredicate();
            final boolean acceptNulls = ((UserDefinedPredicate)predicate).acceptsNullValue();
            if (acceptNulls && this.nullCounts == null) {
                return IndexIterator.all(this.getPageCount());
            }
            return IndexIterator.filter(this.getPageCount(), new IntPredicate((UserDefinedPredicate)predicate){
                private int arrayIndex = -1;
                final /* synthetic */ UserDefinedPredicate val$predicate;
                {
                    this.val$predicate = userDefinedPredicate;
                }

                @Override
                public boolean test(int pageIndex) {
                    if (this.isNullPage(pageIndex)) {
                        return acceptNulls;
                    }
                    ++this.arrayIndex;
                    if (acceptNulls && nullCounts[pageIndex] > 0L) {
                        return true;
                    }
                    Statistics stats = this.createStats(this.arrayIndex);
                    return !this.val$predicate.canDrop(stats);
                }
            });
        }

        @Override
        public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> PrimitiveIterator.OfInt visit(Operators.LogicalNotUserDefined<T, U> udp) {
            boolean acceptNulls;
            U inversePredicate = udp.getUserDefined().getUserDefinedPredicate();
            boolean bl = acceptNulls = !((UserDefinedPredicate)inversePredicate).acceptsNullValue();
            if (acceptNulls && this.nullCounts == null) {
                return IndexIterator.all(this.getPageCount());
            }
            return IndexIterator.filter(this.getPageCount(), new IntPredicate((UserDefinedPredicate)inversePredicate){
                private int arrayIndex = -1;
                final /* synthetic */ UserDefinedPredicate val$inversePredicate;
                {
                    this.val$inversePredicate = userDefinedPredicate;
                }

                @Override
                public boolean test(int pageIndex) {
                    if (this.isNullPage(pageIndex)) {
                        return acceptNulls;
                    }
                    ++this.arrayIndex;
                    if (acceptNulls && nullCounts[pageIndex] > 0L) {
                        return true;
                    }
                    Statistics stats = this.createStats(this.arrayIndex);
                    return !this.val$inversePredicate.inverseCanDrop(stats);
                }
            });
        }

        static /* synthetic */ boolean[] access$302(ColumnIndexBase x0, boolean[] x1) {
            x0.nullPages = x1;
            return x1;
        }

        static /* synthetic */ long[] access$102(ColumnIndexBase x0, long[] x1) {
            x0.nullCounts = x1;
            return x1;
        }

        static /* synthetic */ int[] access$002(ColumnIndexBase x0, int[] x1) {
            x0.pageIndexes = x1;
            return x1;
        }

        abstract class ValueComparator {
            ValueComparator() {
            }

            abstract int compareValueToMin(int var1);

            abstract int compareValueToMax(int var1);

            int arrayLength() {
                return ColumnIndexBase.this.pageIndexes.length;
            }

            int translate(int arrayIndex) {
                return ColumnIndexBase.this.pageIndexes[arrayIndex];
            }
        }
    }
}

