/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.ftp.config;

import java.util.HashMap;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.ftp.config.FtpConfigOptions;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class FtpConf
extends HadoopConf {
    private static final String HDFS_IMPL = "org.apache.seatunnel.connectors.seatunnel.file.ftp.system.SeaTunnelFTPFileSystem";
    private static final String SCHEMA = "ftp";

    private FtpConf(String hdfsNameKey) {
        super(hdfsNameKey);
    }

    @Override
    public String getFsHdfsImpl() {
        return HDFS_IMPL;
    }

    @Override
    public String getSchema() {
        return SCHEMA;
    }

    public static HadoopConf buildWithConfig(Config config) {
        String host = config.getString(FtpConfigOptions.FTP_HOST.key());
        int port = config.getInt(FtpConfigOptions.FTP_PORT.key());
        String defaultFS = String.format("ftp://%s:%s", host, port);
        FtpConf hadoopConf = new FtpConf(defaultFS);
        HashMap<String, String> ftpOptions = new HashMap<String, String>();
        ftpOptions.put("fs.ftp.user." + host, config.getString(FtpConfigOptions.FTP_USERNAME.key()));
        ftpOptions.put("fs.ftp.password." + host, config.getString(FtpConfigOptions.FTP_PASSWORD.key()));
        if (config.hasPath(FtpConfigOptions.FTP_CONNECTION_MODE.key())) {
            ftpOptions.put("fs.ftp.connection.mode", config.getString(FtpConfigOptions.FTP_CONNECTION_MODE.key()));
        }
        hadoopConf.setExtraOptions(ftpOptions);
        return hadoopConf;
    }
}

