/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.ftp.source;

import com.google.auto.service.AutoService;
import java.io.IOException;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.catalog.schema.TableSchemaOptions;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileSystemType;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.ftp.config.FtpConf;
import org.apache.seatunnel.connectors.seatunnel.file.ftp.config.FtpConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.file.source.BaseFileSource;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.ReadStrategyFactory;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={SeaTunnelSource.class})
public class FtpFileSource
extends BaseFileSource {
    public String getPluginName() {
        return FileSystemType.FTP.getFileSystemPluginName();
    }

    public void prepare(Config pluginConfig) throws PrepareFailException {
        block12: {
            block11: {
                CheckResult result = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{FtpConfigOptions.FILE_PATH.key(), FtpConfigOptions.FILE_FORMAT_TYPE.key(), FtpConfigOptions.FTP_HOST.key(), FtpConfigOptions.FTP_PORT.key(), FtpConfigOptions.FTP_USERNAME.key(), FtpConfigOptions.FTP_PASSWORD.key()});
                if (!result.isSuccess()) {
                    throw new FileConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", this.getPluginName(), PluginType.SOURCE, result.getMsg()));
                }
                FileFormat fileFormat = FileFormat.valueOf(pluginConfig.getString(FtpConfigOptions.FILE_FORMAT_TYPE.key()).toUpperCase());
                if (fileFormat == FileFormat.ORC || fileFormat == FileFormat.PARQUET) {
                    throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "Ftp file source connector only support read [text, csv, json] files");
                }
                String path = pluginConfig.getString(FtpConfigOptions.FILE_PATH.key());
                this.hadoopConf = FtpConf.buildWithConfig(pluginConfig);
                this.readStrategy = ReadStrategyFactory.of(pluginConfig.getString(FtpConfigOptions.FILE_FORMAT_TYPE.key()));
                this.readStrategy.setPluginConfig(pluginConfig);
                this.readStrategy.init(this.hadoopConf);
                try {
                    this.filePaths = this.readStrategy.getFileNamesByPath(path);
                }
                catch (IOException e) {
                    String errorMsg = String.format("Get file list from this path [%s] failed", path);
                    throw new FileConnectorException(FileConnectorErrorCode.FILE_LIST_GET_FAILED, errorMsg, e);
                }
                if (!pluginConfig.hasPath(TableSchemaOptions.SCHEMA.key())) break block11;
                switch (fileFormat) {
                    case CSV: 
                    case TEXT: 
                    case JSON: 
                    case EXCEL: 
                    case XML: {
                        SeaTunnelRowType userDefinedSchema = CatalogTableUtil.buildWithConfig((Config)pluginConfig).getSeaTunnelRowType();
                        this.readStrategy.setSeaTunnelRowTypeInfo(userDefinedSchema);
                        this.rowType = this.readStrategy.getActualSeaTunnelRowTypeInfo();
                        break block12;
                    }
                    case ORC: 
                    case PARQUET: 
                    case BINARY: {
                        throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, "SeaTunnel does not support user-defined schema for [parquet, orc, binary] files");
                    }
                    default: {
                        throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "SeaTunnel does not supported this file format");
                    }
                }
            }
            if (this.filePaths.isEmpty()) {
                this.rowType = CatalogTableUtil.buildSimpleTextSchema();
                return;
            }
            try {
                this.rowType = this.readStrategy.getSeaTunnelRowTypeInfo((String)this.filePaths.get(0));
            }
            catch (FileConnectorException e) {
                String errorMsg = String.format("Get table schema from file [%s] failed", this.filePaths.get(0));
                throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.TABLE_SCHEMA_GET_FAILED, errorMsg, (Throwable)((Object)e));
            }
        }
    }
}

