/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.file.org.apache.parquet.column;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.column.Encoding;

public class EncodingStats {
    final Map<Encoding, Number> dictStats;
    final Map<Encoding, Number> dataStats;
    private final boolean usesV2Pages;

    private EncodingStats(Map<Encoding, Number> dictStats, Map<Encoding, Number> dataStats, boolean usesV2Pages) {
        this.dictStats = dictStats;
        this.dataStats = dataStats;
        this.usesV2Pages = usesV2Pages;
    }

    public Set<Encoding> getDictionaryEncodings() {
        return this.dictStats.keySet();
    }

    public Set<Encoding> getDataEncodings() {
        return this.dataStats.keySet();
    }

    public int getNumDictionaryPagesEncodedAs(Encoding enc) {
        Number pageCount = this.dictStats.get((Object)enc);
        return pageCount == null ? 0 : pageCount.intValue();
    }

    public int getNumDataPagesEncodedAs(Encoding enc) {
        Number pageCount = this.dataStats.get((Object)enc);
        return pageCount == null ? 0 : pageCount.intValue();
    }

    public boolean hasDictionaryPages() {
        return !this.dictStats.isEmpty();
    }

    public boolean hasDictionaryEncodedPages() {
        Set<Encoding> encodings = this.dataStats.keySet();
        return encodings.contains((Object)Encoding.RLE_DICTIONARY) || encodings.contains((Object)Encoding.PLAIN_DICTIONARY);
    }

    public boolean hasNonDictionaryEncodedPages() {
        if (this.dataStats.isEmpty()) {
            return false;
        }
        HashSet<Encoding> encodings = new HashSet<Encoding>(this.dataStats.keySet());
        if (!encodings.remove((Object)Encoding.RLE_DICTIONARY) && !encodings.remove((Object)Encoding.PLAIN_DICTIONARY)) {
            return true;
        }
        return !encodings.isEmpty();
    }

    public boolean usesV2Pages() {
        return this.usesV2Pages;
    }

    public static class Builder {
        private final Map<Encoding, AtomicInteger> dictStats = new LinkedHashMap<Encoding, AtomicInteger>();
        private final Map<Encoding, AtomicInteger> dataStats = new LinkedHashMap<Encoding, AtomicInteger>();
        private boolean usesV2Pages = false;

        public Builder clear() {
            this.usesV2Pages = false;
            this.dictStats.clear();
            this.dataStats.clear();
            return this;
        }

        public Builder withV2Pages() {
            this.usesV2Pages = true;
            return this;
        }

        public Builder addDictEncoding(Encoding encoding) {
            return this.addDictEncoding(encoding, 1);
        }

        public Builder addDictEncoding(Encoding encoding, int numPages) {
            this.dictStats.computeIfAbsent(encoding, enc -> new AtomicInteger(0)).addAndGet(numPages);
            return this;
        }

        public Builder addDataEncodings(Collection<Encoding> encodings) {
            for (Encoding encoding : encodings) {
                this.addDataEncoding(encoding);
            }
            return this;
        }

        public Builder addDataEncoding(Encoding encoding) {
            return this.addDataEncoding(encoding, 1);
        }

        public Builder addDataEncoding(Encoding encoding, int numPages) {
            this.dataStats.computeIfAbsent(encoding, enc -> new AtomicInteger(0)).addAndGet(numPages);
            return this;
        }

        public EncodingStats build() {
            return new EncodingStats(Collections.unmodifiableMap(new LinkedHashMap<Encoding, AtomicInteger>(this.dictStats)), Collections.unmodifiableMap(new LinkedHashMap<Encoding, AtomicInteger>(this.dataStats)), this.usesV2Pages);
        }
    }
}

