/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class HadoopConf
implements Serializable {
    private static final String HDFS_IMPL = "org.apache.hadoop.hdfs.DistributedFileSystem";
    private static final String SCHEMA = "hdfs";
    protected Map<String, String> extraOptions = new HashMap<String, String>();
    protected String hdfsNameKey;
    protected String hdfsSitePath;
    protected String kerberosPrincipal;
    protected String kerberosKeytabPath;

    public HadoopConf(String hdfsNameKey) {
        this.hdfsNameKey = hdfsNameKey;
    }

    public String getFsHdfsImpl() {
        return HDFS_IMPL;
    }

    public String getSchema() {
        return SCHEMA;
    }

    public void setExtraOptionsForConfiguration(Configuration configuration) {
        if (!this.extraOptions.isEmpty()) {
            this.extraOptions.forEach((arg_0, arg_1) -> ((Configuration)configuration).set(arg_0, arg_1));
        }
        if (this.hdfsSitePath != null) {
            configuration.addResource(new Path(this.hdfsSitePath));
        }
    }

    public Map<String, String> getExtraOptions() {
        return this.extraOptions;
    }

    public String getHdfsNameKey() {
        return this.hdfsNameKey;
    }

    public String getHdfsSitePath() {
        return this.hdfsSitePath;
    }

    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public String getKerberosKeytabPath() {
        return this.kerberosKeytabPath;
    }

    public void setExtraOptions(Map<String, String> extraOptions) {
        this.extraOptions = extraOptions;
    }

    public void setHdfsNameKey(String hdfsNameKey) {
        this.hdfsNameKey = hdfsNameKey;
    }

    public void setHdfsSitePath(String hdfsSitePath) {
        this.hdfsSitePath = hdfsSitePath;
    }

    public void setKerberosPrincipal(String kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
    }

    public void setKerberosKeytabPath(String kerberosKeytabPath) {
        this.kerberosKeytabPath = kerberosKeytabPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HadoopConf)) {
            return false;
        }
        HadoopConf other = (HadoopConf)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$extraOptions = this.getExtraOptions();
        Map<String, String> other$extraOptions = other.getExtraOptions();
        if (this$extraOptions == null ? other$extraOptions != null : !((Object)this$extraOptions).equals(other$extraOptions)) {
            return false;
        }
        String this$hdfsNameKey = this.getHdfsNameKey();
        String other$hdfsNameKey = other.getHdfsNameKey();
        if (this$hdfsNameKey == null ? other$hdfsNameKey != null : !this$hdfsNameKey.equals(other$hdfsNameKey)) {
            return false;
        }
        String this$hdfsSitePath = this.getHdfsSitePath();
        String other$hdfsSitePath = other.getHdfsSitePath();
        if (this$hdfsSitePath == null ? other$hdfsSitePath != null : !this$hdfsSitePath.equals(other$hdfsSitePath)) {
            return false;
        }
        String this$kerberosPrincipal = this.getKerberosPrincipal();
        String other$kerberosPrincipal = other.getKerberosPrincipal();
        if (this$kerberosPrincipal == null ? other$kerberosPrincipal != null : !this$kerberosPrincipal.equals(other$kerberosPrincipal)) {
            return false;
        }
        String this$kerberosKeytabPath = this.getKerberosKeytabPath();
        String other$kerberosKeytabPath = other.getKerberosKeytabPath();
        return !(this$kerberosKeytabPath == null ? other$kerberosKeytabPath != null : !this$kerberosKeytabPath.equals(other$kerberosKeytabPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HadoopConf;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $extraOptions = this.getExtraOptions();
        result = result * 59 + ($extraOptions == null ? 43 : ((Object)$extraOptions).hashCode());
        String $hdfsNameKey = this.getHdfsNameKey();
        result = result * 59 + ($hdfsNameKey == null ? 43 : $hdfsNameKey.hashCode());
        String $hdfsSitePath = this.getHdfsSitePath();
        result = result * 59 + ($hdfsSitePath == null ? 43 : $hdfsSitePath.hashCode());
        String $kerberosPrincipal = this.getKerberosPrincipal();
        result = result * 59 + ($kerberosPrincipal == null ? 43 : $kerberosPrincipal.hashCode());
        String $kerberosKeytabPath = this.getKerberosKeytabPath();
        result = result * 59 + ($kerberosKeytabPath == null ? 43 : $kerberosKeytabPath.hashCode());
        return result;
    }

    public String toString() {
        return "HadoopConf(extraOptions=" + this.getExtraOptions() + ", hdfsNameKey=" + this.getHdfsNameKey() + ", hdfsSitePath=" + this.getHdfsSitePath() + ", kerberosPrincipal=" + this.getKerberosPrincipal() + ", kerberosKeytabPath=" + this.getKerberosKeytabPath() + ")";
    }
}

