/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.sink.commit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.sink.SinkAggregatedCommitter;
import org.apache.seatunnel.connectors.seatunnel.file.sink.commit.FileAggregatedCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.file.sink.commit.FileCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.file.sink.util.FileSystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSinkAggregatedCommitter
implements SinkAggregatedCommitter<FileCommitInfo, FileAggregatedCommitInfo> {
    private static final Logger log = LoggerFactory.getLogger(FileSinkAggregatedCommitter.class);
    protected final FileSystemUtils fileSystemUtils;

    public FileSinkAggregatedCommitter(FileSystemUtils fileSystemUtils) {
        this.fileSystemUtils = fileSystemUtils;
    }

    public List<FileAggregatedCommitInfo> commit(List<FileAggregatedCommitInfo> aggregatedCommitInfos) throws IOException {
        ArrayList<FileAggregatedCommitInfo> errorAggregatedCommitInfoList = new ArrayList<FileAggregatedCommitInfo>();
        aggregatedCommitInfos.forEach(aggregatedCommitInfo -> {
            try {
                for (Map.Entry<String, LinkedHashMap<String, String>> entry : aggregatedCommitInfo.getTransactionMap().entrySet()) {
                    for (Map.Entry<String, String> mvFileEntry : entry.getValue().entrySet()) {
                        this.fileSystemUtils.renameFile(mvFileEntry.getKey(), mvFileEntry.getValue(), true);
                    }
                    this.fileSystemUtils.deleteFile(entry.getKey());
                }
            }
            catch (Exception e) {
                log.error("commit aggregatedCommitInfo error, aggregatedCommitInfo = {} ", aggregatedCommitInfo, (Object)e);
                errorAggregatedCommitInfoList.add((FileAggregatedCommitInfo)aggregatedCommitInfo);
            }
        });
        return errorAggregatedCommitInfoList;
    }

    public FileAggregatedCommitInfo combine(List<FileCommitInfo> commitInfos) {
        if (commitInfos == null || commitInfos.size() == 0) {
            return null;
        }
        LinkedHashMap<String, LinkedHashMap<String, String>> aggregateCommitInfo = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        LinkedHashMap<String, List<String>> partitionDirAndValuesMap = new LinkedHashMap<String, List<String>>();
        commitInfos.forEach(commitInfo -> {
            LinkedHashMap needMoveFileMap = aggregateCommitInfo.computeIfAbsent(commitInfo.getTransactionDir(), k -> new LinkedHashMap());
            needMoveFileMap.putAll(commitInfo.getNeedMoveFiles());
            if (commitInfo.getPartitionDirAndValuesMap() != null && !commitInfo.getPartitionDirAndValuesMap().isEmpty()) {
                partitionDirAndValuesMap.putAll(commitInfo.getPartitionDirAndValuesMap());
            }
        });
        return new FileAggregatedCommitInfo(aggregateCommitInfo, partitionDirAndValuesMap);
    }

    public void abort(List<FileAggregatedCommitInfo> aggregatedCommitInfos) throws Exception {
        log.info("rollback aggregate commit");
        if (aggregatedCommitInfos == null || aggregatedCommitInfos.size() == 0) {
            return;
        }
        aggregatedCommitInfos.forEach(aggregatedCommitInfo -> {
            try {
                for (Map.Entry<String, LinkedHashMap<String, String>> entry : aggregatedCommitInfo.getTransactionMap().entrySet()) {
                    for (Map.Entry<String, String> mvFileEntry : entry.getValue().entrySet()) {
                        if (!this.fileSystemUtils.fileExist(mvFileEntry.getValue()) || this.fileSystemUtils.fileExist(mvFileEntry.getKey())) continue;
                        this.fileSystemUtils.renameFile(mvFileEntry.getValue(), mvFileEntry.getKey(), true);
                    }
                    this.fileSystemUtils.deleteFile(entry.getKey());
                }
            }
            catch (Exception e) {
                log.error("abort aggregatedCommitInfo error ", (Throwable)e);
            }
        });
    }

    public void close() throws IOException {
    }
}

