/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.sink.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseFileSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.PartitionConfig;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class FileSinkConfig
extends BaseFileSinkConfig
implements PartitionConfig {
    private List<String> sinkColumnList;
    private List<String> partitionFieldList;
    private String partitionDirExpression;
    private boolean isPartitionFieldWriteInFile = (Boolean)BaseSinkConfig.IS_PARTITION_FIELD_WRITE_IN_FILE.defaultValue();
    private String tmpPath = (String)BaseSinkConfig.TMP_PATH.defaultValue();
    private String fileNameTimeFormat = (String)BaseSinkConfig.FILENAME_TIME_FORMAT.defaultValue();
    private boolean isEnableTransaction = (Boolean)BaseSinkConfig.IS_ENABLE_TRANSACTION.defaultValue();
    private List<Integer> sinkColumnsIndexInRow;
    private List<Integer> partitionFieldsIndexInRow;
    private int maxRowsInMemory;
    private String sheetName;

    public FileSinkConfig(@NonNull Config config, @NonNull SeaTunnelRowType seaTunnelRowTypeInfo) {
        super(config);
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (seaTunnelRowTypeInfo == null) {
            throw new NullPointerException("seaTunnelRowTypeInfo is marked non-null but is null");
        }
        Preconditions.checkArgument((!CollectionUtils.isEmpty(Arrays.asList(seaTunnelRowTypeInfo.getFieldNames())) ? 1 : 0) != 0);
        if (config.hasPath(BaseSinkConfig.SINK_COLUMNS.key()) && !CollectionUtils.isEmpty(config.getStringList(BaseSinkConfig.SINK_COLUMNS.key()))) {
            this.sinkColumnList = config.getStringList(BaseSinkConfig.SINK_COLUMNS.key());
        }
        if (CollectionUtils.isEmpty(this.sinkColumnList)) {
            this.sinkColumnList = Arrays.asList(seaTunnelRowTypeInfo.getFieldNames());
        }
        this.partitionFieldList = config.hasPath(BaseSinkConfig.PARTITION_BY.key()) ? config.getStringList(BaseSinkConfig.PARTITION_BY.key()) : Collections.emptyList();
        if (config.hasPath(BaseSinkConfig.PARTITION_DIR_EXPRESSION.key()) && !StringUtils.isBlank(config.getString(BaseSinkConfig.PARTITION_DIR_EXPRESSION.key()))) {
            this.partitionDirExpression = config.getString(BaseSinkConfig.PARTITION_DIR_EXPRESSION.key());
        }
        if (config.hasPath(BaseSinkConfig.IS_PARTITION_FIELD_WRITE_IN_FILE.key())) {
            this.isPartitionFieldWriteInFile = config.getBoolean(BaseSinkConfig.IS_PARTITION_FIELD_WRITE_IN_FILE.key());
        }
        if (config.hasPath(BaseSinkConfig.TMP_PATH.key()) && !StringUtils.isBlank(config.getString(BaseSinkConfig.TMP_PATH.key()))) {
            this.tmpPath = config.getString(BaseSinkConfig.TMP_PATH.key());
        }
        if (config.hasPath(BaseSinkConfig.FILENAME_TIME_FORMAT.key()) && !StringUtils.isBlank(config.getString(BaseSinkConfig.FILENAME_TIME_FORMAT.key()))) {
            this.fileNameTimeFormat = config.getString(BaseSinkConfig.FILENAME_TIME_FORMAT.key());
        }
        if (config.hasPath(BaseSinkConfig.IS_ENABLE_TRANSACTION.key())) {
            this.isEnableTransaction = config.getBoolean(BaseSinkConfig.IS_ENABLE_TRANSACTION.key());
        }
        if (this.isEnableTransaction && !this.fileNameExpression.contains("transactionId")) {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.ILLEGAL_ARGUMENT, "file_name_expression must contains transactionId when is_enable_transaction is true");
        }
        if (!(CollectionUtils.isEmpty(this.partitionFieldList) || !CollectionUtils.isEmpty(this.sinkColumnList) && new HashSet<String>(this.sinkColumnList).containsAll(this.partitionFieldList))) {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.ILLEGAL_ARGUMENT, "partition fields must in sink columns");
        }
        if (!(CollectionUtils.isEmpty(this.partitionFieldList) || this.isPartitionFieldWriteInFile || this.sinkColumnList.removeAll(this.partitionFieldList))) {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.ILLEGAL_ARGUMENT, "remove partition field from sink columns error");
        }
        if (CollectionUtils.isEmpty(this.sinkColumnList)) {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.ILLEGAL_ARGUMENT, "sink columns can not be empty");
        }
        HashMap<String, Integer> columnsMap = new HashMap<String, Integer>(seaTunnelRowTypeInfo.getFieldNames().length);
        String[] fieldNames = seaTunnelRowTypeInfo.getFieldNames();
        for (int i = 0; i < fieldNames.length; ++i) {
            columnsMap.put(fieldNames[i].toLowerCase(), i);
        }
        this.sinkColumnsIndexInRow = this.sinkColumnList.stream().map(column -> (Integer)columnsMap.get(column.toLowerCase())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(this.partitionFieldList)) {
            this.partitionFieldsIndexInRow = this.partitionFieldList.stream().map(columnsMap::get).collect(Collectors.toList());
        }
        if (config.hasPath(BaseSinkConfig.MAX_ROWS_IN_MEMORY.key())) {
            this.maxRowsInMemory = config.getInt(BaseSinkConfig.MAX_ROWS_IN_MEMORY.key());
        }
        if (config.hasPath(BaseSinkConfig.SHEET_NAME.key())) {
            this.sheetName = config.getString(BaseSinkConfig.SHEET_NAME.key());
        }
    }

    public List<String> getSinkColumnList() {
        return this.sinkColumnList;
    }

    @Override
    public List<String> getPartitionFieldList() {
        return this.partitionFieldList;
    }

    public String getPartitionDirExpression() {
        return this.partitionDirExpression;
    }

    @Override
    public boolean isPartitionFieldWriteInFile() {
        return this.isPartitionFieldWriteInFile;
    }

    public String getTmpPath() {
        return this.tmpPath;
    }

    public String getFileNameTimeFormat() {
        return this.fileNameTimeFormat;
    }

    public boolean isEnableTransaction() {
        return this.isEnableTransaction;
    }

    public List<Integer> getSinkColumnsIndexInRow() {
        return this.sinkColumnsIndexInRow;
    }

    public List<Integer> getPartitionFieldsIndexInRow() {
        return this.partitionFieldsIndexInRow;
    }

    public int getMaxRowsInMemory() {
        return this.maxRowsInMemory;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSinkColumnList(List<String> sinkColumnList) {
        this.sinkColumnList = sinkColumnList;
    }

    public void setPartitionFieldList(List<String> partitionFieldList) {
        this.partitionFieldList = partitionFieldList;
    }

    public void setPartitionDirExpression(String partitionDirExpression) {
        this.partitionDirExpression = partitionDirExpression;
    }

    public void setPartitionFieldWriteInFile(boolean isPartitionFieldWriteInFile) {
        this.isPartitionFieldWriteInFile = isPartitionFieldWriteInFile;
    }

    public void setTmpPath(String tmpPath) {
        this.tmpPath = tmpPath;
    }

    public void setFileNameTimeFormat(String fileNameTimeFormat) {
        this.fileNameTimeFormat = fileNameTimeFormat;
    }

    public void setEnableTransaction(boolean isEnableTransaction) {
        this.isEnableTransaction = isEnableTransaction;
    }

    public void setSinkColumnsIndexInRow(List<Integer> sinkColumnsIndexInRow) {
        this.sinkColumnsIndexInRow = sinkColumnsIndexInRow;
    }

    public void setPartitionFieldsIndexInRow(List<Integer> partitionFieldsIndexInRow) {
        this.partitionFieldsIndexInRow = partitionFieldsIndexInRow;
    }

    public void setMaxRowsInMemory(int maxRowsInMemory) {
        this.maxRowsInMemory = maxRowsInMemory;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSinkConfig)) {
            return false;
        }
        FileSinkConfig other = (FileSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPartitionFieldWriteInFile() != other.isPartitionFieldWriteInFile()) {
            return false;
        }
        if (this.isEnableTransaction() != other.isEnableTransaction()) {
            return false;
        }
        if (this.getMaxRowsInMemory() != other.getMaxRowsInMemory()) {
            return false;
        }
        List<String> this$sinkColumnList = this.getSinkColumnList();
        List<String> other$sinkColumnList = other.getSinkColumnList();
        if (this$sinkColumnList == null ? other$sinkColumnList != null : !((Object)this$sinkColumnList).equals(other$sinkColumnList)) {
            return false;
        }
        List<String> this$partitionFieldList = this.getPartitionFieldList();
        List<String> other$partitionFieldList = other.getPartitionFieldList();
        if (this$partitionFieldList == null ? other$partitionFieldList != null : !((Object)this$partitionFieldList).equals(other$partitionFieldList)) {
            return false;
        }
        String this$partitionDirExpression = this.getPartitionDirExpression();
        String other$partitionDirExpression = other.getPartitionDirExpression();
        if (this$partitionDirExpression == null ? other$partitionDirExpression != null : !this$partitionDirExpression.equals(other$partitionDirExpression)) {
            return false;
        }
        String this$tmpPath = this.getTmpPath();
        String other$tmpPath = other.getTmpPath();
        if (this$tmpPath == null ? other$tmpPath != null : !this$tmpPath.equals(other$tmpPath)) {
            return false;
        }
        String this$fileNameTimeFormat = this.getFileNameTimeFormat();
        String other$fileNameTimeFormat = other.getFileNameTimeFormat();
        if (this$fileNameTimeFormat == null ? other$fileNameTimeFormat != null : !this$fileNameTimeFormat.equals(other$fileNameTimeFormat)) {
            return false;
        }
        List<Integer> this$sinkColumnsIndexInRow = this.getSinkColumnsIndexInRow();
        List<Integer> other$sinkColumnsIndexInRow = other.getSinkColumnsIndexInRow();
        if (this$sinkColumnsIndexInRow == null ? other$sinkColumnsIndexInRow != null : !((Object)this$sinkColumnsIndexInRow).equals(other$sinkColumnsIndexInRow)) {
            return false;
        }
        List<Integer> this$partitionFieldsIndexInRow = this.getPartitionFieldsIndexInRow();
        List<Integer> other$partitionFieldsIndexInRow = other.getPartitionFieldsIndexInRow();
        if (this$partitionFieldsIndexInRow == null ? other$partitionFieldsIndexInRow != null : !((Object)this$partitionFieldsIndexInRow).equals(other$partitionFieldsIndexInRow)) {
            return false;
        }
        String this$sheetName = this.getSheetName();
        String other$sheetName = other.getSheetName();
        return !(this$sheetName == null ? other$sheetName != null : !this$sheetName.equals(other$sheetName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FileSinkConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPartitionFieldWriteInFile() ? 79 : 97);
        result = result * 59 + (this.isEnableTransaction() ? 79 : 97);
        result = result * 59 + this.getMaxRowsInMemory();
        List<String> $sinkColumnList = this.getSinkColumnList();
        result = result * 59 + ($sinkColumnList == null ? 43 : ((Object)$sinkColumnList).hashCode());
        List<String> $partitionFieldList = this.getPartitionFieldList();
        result = result * 59 + ($partitionFieldList == null ? 43 : ((Object)$partitionFieldList).hashCode());
        String $partitionDirExpression = this.getPartitionDirExpression();
        result = result * 59 + ($partitionDirExpression == null ? 43 : $partitionDirExpression.hashCode());
        String $tmpPath = this.getTmpPath();
        result = result * 59 + ($tmpPath == null ? 43 : $tmpPath.hashCode());
        String $fileNameTimeFormat = this.getFileNameTimeFormat();
        result = result * 59 + ($fileNameTimeFormat == null ? 43 : $fileNameTimeFormat.hashCode());
        List<Integer> $sinkColumnsIndexInRow = this.getSinkColumnsIndexInRow();
        result = result * 59 + ($sinkColumnsIndexInRow == null ? 43 : ((Object)$sinkColumnsIndexInRow).hashCode());
        List<Integer> $partitionFieldsIndexInRow = this.getPartitionFieldsIndexInRow();
        result = result * 59 + ($partitionFieldsIndexInRow == null ? 43 : ((Object)$partitionFieldsIndexInRow).hashCode());
        String $sheetName = this.getSheetName();
        result = result * 59 + ($sheetName == null ? 43 : $sheetName.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "FileSinkConfig(sinkColumnList=" + this.getSinkColumnList() + ", partitionFieldList=" + this.getPartitionFieldList() + ", partitionDirExpression=" + this.getPartitionDirExpression() + ", isPartitionFieldWriteInFile=" + this.isPartitionFieldWriteInFile() + ", tmpPath=" + this.getTmpPath() + ", fileNameTimeFormat=" + this.getFileNameTimeFormat() + ", isEnableTransaction=" + this.isEnableTransaction() + ", sinkColumnsIndexInRow=" + this.getSinkColumnsIndexInRow() + ", partitionFieldsIndexInRow=" + this.getPartitionFieldsIndexInRow() + ", maxRowsInMemory=" + this.getMaxRowsInMemory() + ", sheetName=" + this.getSheetName() + ")";
    }
}

