/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.source.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.DateTimeUtils;
import org.apache.seatunnel.common.utils.DateUtils;
import org.apache.seatunnel.common.utils.TimeUtils;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.AbstractReadStrategy;
import org.apache.seatunnel.format.text.TextDeserializationSchema;

public class TextReadStrategy
extends AbstractReadStrategy {
    private DeserializationSchema<SeaTunnelRow> deserializationSchema;
    private String fieldDelimiter = (String)BaseSourceConfig.DELIMITER.defaultValue();
    private DateUtils.Formatter dateFormat = (DateUtils.Formatter)BaseSourceConfig.DATE_FORMAT.defaultValue();
    private DateTimeUtils.Formatter datetimeFormat = (DateTimeUtils.Formatter)BaseSourceConfig.DATETIME_FORMAT.defaultValue();
    private TimeUtils.Formatter timeFormat = (TimeUtils.Formatter)BaseSourceConfig.TIME_FORMAT.defaultValue();
    private int[] indexes;

    @Override
    public void read(String path, Collector<SeaTunnelRow> output) throws FileConnectorException, IOException {
        Configuration conf = this.getConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path filePath = new Path(path);
        Map<String, String> partitionsMap = this.parsePartitionsByPath(path);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fs.open(filePath), StandardCharsets.UTF_8));){
            reader.lines().skip(this.skipHeaderNumber).forEach(line -> {
                try {
                    SeaTunnelRow seaTunnelRow = (SeaTunnelRow)this.deserializationSchema.deserialize(line.getBytes());
                    if (!this.readColumns.isEmpty()) {
                        Object[] fields = this.isMergePartition ? new Object[this.readColumns.size() + partitionsMap.size()] : new Object[this.readColumns.size()];
                        for (int i = 0; i < this.indexes.length; ++i) {
                            fields[i] = seaTunnelRow.getField(this.indexes[i]);
                        }
                        seaTunnelRow = new SeaTunnelRow(fields);
                    }
                    if (this.isMergePartition) {
                        int index = this.seaTunnelRowType.getTotalFields();
                        for (String value : partitionsMap.values()) {
                            seaTunnelRow.setField(index++, (Object)value);
                        }
                    }
                    output.collect((Object)seaTunnelRow);
                }
                catch (IOException e) {
                    String errorMsg = String.format("Deserialize this data [%s] failed, please check the origin data", line);
                    throw new FileConnectorException(FileConnectorErrorCode.DATA_DESERIALIZE_FAILED, errorMsg, e);
                }
            });
        }
    }

    @Override
    public SeaTunnelRowType getSeaTunnelRowTypeInfo(HadoopConf hadoopConf, String path) {
        this.seaTunnelRowType = CatalogTableUtil.buildSimpleTextSchema();
        this.seaTunnelRowTypeWithPartition = this.mergePartitionTypes((String)this.fileNames.get(0), this.seaTunnelRowType);
        this.initFormatter();
        if (this.pluginConfig.hasPath(BaseSourceConfig.READ_COLUMNS.key())) {
            throw new FileConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, "When reading json/text/csv files, if user has not specified schema information, SeaTunnel will not support column projection");
        }
        TextDeserializationSchema.Builder builder = TextDeserializationSchema.builder().delimiter("\b").dateFormatter(this.dateFormat).dateTimeFormatter(this.datetimeFormat).timeFormatter(this.timeFormat);
        this.deserializationSchema = this.isMergePartition ? builder.seaTunnelRowType(this.seaTunnelRowTypeWithPartition).build() : builder.seaTunnelRowType(this.seaTunnelRowType).build();
        return this.getActualSeaTunnelRowTypeInfo();
    }

    @Override
    public void setSeaTunnelRowTypeInfo(SeaTunnelRowType seaTunnelRowType) {
        SeaTunnelRowType userDefinedRowTypeWithPartition = this.mergePartitionTypes((String)this.fileNames.get(0), seaTunnelRowType);
        if (this.pluginConfig.hasPath(BaseSourceConfig.DELIMITER.key())) {
            this.fieldDelimiter = this.pluginConfig.getString(BaseSourceConfig.DELIMITER.key());
        } else {
            FileFormat fileFormat = FileFormat.valueOf(this.pluginConfig.getString(BaseSourceConfig.FILE_FORMAT_TYPE.key()).toUpperCase());
            if (fileFormat == FileFormat.CSV) {
                this.fieldDelimiter = ",";
            }
        }
        this.initFormatter();
        TextDeserializationSchema.Builder builder = TextDeserializationSchema.builder().delimiter(this.fieldDelimiter).dateFormatter(this.dateFormat).dateTimeFormatter(this.datetimeFormat).timeFormatter(this.timeFormat);
        this.deserializationSchema = this.isMergePartition ? builder.seaTunnelRowType(userDefinedRowTypeWithPartition).build() : builder.seaTunnelRowType(seaTunnelRowType).build();
        if (this.pluginConfig.hasPath(BaseSourceConfig.READ_COLUMNS.key())) {
            this.indexes = new int[this.readColumns.size()];
            String[] fields = new String[this.readColumns.size()];
            SeaTunnelDataType[] types = new SeaTunnelDataType[this.readColumns.size()];
            for (int i = 0; i < this.indexes.length; ++i) {
                this.indexes[i] = seaTunnelRowType.indexOf((String)this.readColumns.get(i));
                fields[i] = seaTunnelRowType.getFieldName(this.indexes[i]);
                types[i] = seaTunnelRowType.getFieldType(this.indexes[i]);
            }
            this.seaTunnelRowType = new SeaTunnelRowType(fields, types);
            this.seaTunnelRowTypeWithPartition = this.mergePartitionTypes((String)this.fileNames.get(0), this.seaTunnelRowType);
        } else {
            this.seaTunnelRowType = seaTunnelRowType;
            this.seaTunnelRowTypeWithPartition = userDefinedRowTypeWithPartition;
        }
    }

    private void initFormatter() {
        if (this.pluginConfig.hasPath(BaseSourceConfig.DATE_FORMAT.key())) {
            this.dateFormat = DateUtils.Formatter.parse((String)this.pluginConfig.getString(BaseSourceConfig.DATE_FORMAT.key()));
        }
        if (this.pluginConfig.hasPath(BaseSourceConfig.DATETIME_FORMAT.key())) {
            this.datetimeFormat = DateTimeUtils.Formatter.parse((String)this.pluginConfig.getString(BaseSourceConfig.DATETIME_FORMAT.key()));
        }
        if (this.pluginConfig.hasPath(BaseSourceConfig.TIME_FORMAT.key())) {
            this.timeFormat = TimeUtils.Formatter.parse((String)this.pluginConfig.getString(BaseSourceConfig.TIME_FORMAT.key()));
        }
    }
}

