/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.local.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.schema.TableSchemaOptions;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseSourceConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileSystemType;
import org.apache.seatunnel.connectors.seatunnel.file.local.source.LocalFileSource;

@AutoService(value={Factory.class})
public class LocalFileSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return FileSystemType.LOCAL.getFileSystemPluginName();
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        return () -> new LocalFileSource(context.getOptions());
    }

    public OptionRule optionRule() {
        return OptionRule.builder().optional(new Option[]{BaseSourceConfigOptions.TABLE_CONFIGS}).optional(new Option[]{BaseSourceConfigOptions.FILE_PATH}).optional(new Option[]{BaseSourceConfigOptions.FILE_FORMAT_TYPE}).optional(new Option[]{BaseSourceConfigOptions.ENCODING}).conditional(BaseSourceConfigOptions.FILE_FORMAT_TYPE, (Object)FileFormat.TEXT, new Option[]{BaseSourceConfigOptions.FIELD_DELIMITER}).conditional(BaseSourceConfigOptions.FILE_FORMAT_TYPE, (Object)FileFormat.XML, new Option[]{BaseSourceConfigOptions.XML_ROW_TAG, BaseSourceConfigOptions.XML_USE_ATTR_FORMAT}).conditional(BaseSourceConfigOptions.FILE_FORMAT_TYPE, Arrays.asList(FileFormat.TEXT, FileFormat.JSON, FileFormat.EXCEL, FileFormat.CSV, FileFormat.XML), new Option[]{TableSchemaOptions.SCHEMA}).optional(new Option[]{BaseSourceConfigOptions.PARSE_PARTITION_FROM_PATH}).optional(new Option[]{BaseSourceConfigOptions.DATE_FORMAT}).optional(new Option[]{BaseSourceConfigOptions.DATETIME_FORMAT}).optional(new Option[]{BaseSourceConfigOptions.TIME_FORMAT}).optional(new Option[]{BaseSourceConfigOptions.FILE_FILTER_PATTERN}).build();
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return LocalFileSource.class;
    }
}

