/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.sink.writer;

import io.airlift.compress.lzo.LzopCodec;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.seatunnel.api.serialization.SerializationSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.EncodingUtils;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.sink.config.FileSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.file.sink.writer.AbstractWriteStrategy;
import org.apache.seatunnel.format.json.JsonSerializationSchema;

public class JsonWriteStrategy
extends AbstractWriteStrategy {
    private final byte[] rowDelimiter;
    private SerializationSchema serializationSchema;
    private final LinkedHashMap<String, FSDataOutputStream> beingWrittenOutputStream = new LinkedHashMap();
    private final Map<String, Boolean> isFirstWrite = new HashMap<String, Boolean>();
    private final Charset charset;

    public JsonWriteStrategy(FileSinkConfig textFileSinkConfig) {
        super(textFileSinkConfig);
        this.charset = EncodingUtils.tryParseCharset((String)textFileSinkConfig.getEncoding());
        this.rowDelimiter = textFileSinkConfig.getRowDelimiter().getBytes(this.charset);
    }

    @Override
    public void setSeaTunnelRowTypeInfo(SeaTunnelRowType seaTunnelRowType) {
        super.setSeaTunnelRowTypeInfo(seaTunnelRowType);
        this.serializationSchema = new JsonSerializationSchema(this.buildSchemaWithRowType(seaTunnelRowType, this.sinkColumnsIndexInRow), this.charset);
    }

    @Override
    public void write(@NonNull SeaTunnelRow seaTunnelRow) {
        if (seaTunnelRow == null) {
            throw new NullPointerException("seaTunnelRow is marked non-null but is null");
        }
        super.write(seaTunnelRow);
        String filePath = this.getOrCreateFilePathBeingWritten(seaTunnelRow);
        FSDataOutputStream fsDataOutputStream = this.getOrCreateOutputStream(filePath);
        try {
            byte[] rowBytes = this.serializationSchema.serialize(seaTunnelRow.copy(this.sinkColumnsIndexInRow.stream().mapToInt(Integer::intValue).toArray()));
            if (this.isFirstWrite.get(filePath).booleanValue()) {
                this.isFirstWrite.put(filePath, false);
            } else {
                fsDataOutputStream.write(this.rowDelimiter);
            }
            fsDataOutputStream.write(rowBytes);
        }
        catch (IOException e) {
            throw CommonError.fileOperationFailed((String)"JsonFile", (String)"write", (String)filePath, (Throwable)e);
        }
    }

    @Override
    public void finishAndCloseFile() {
        this.beingWrittenOutputStream.forEach((key, value) -> {
            try {
                value.flush();
            }
            catch (IOException e) {
                throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.FLUSH_DATA_FAILED, String.format("Flush data to this file [%s] failed", key), e);
            }
            finally {
                try {
                    value.close();
                }
                catch (IOException e) {
                    this.log.warn("Close file output stream {} failed", key, (Object)e);
                }
            }
            this.needMoveFiles.put(key, this.getTargetLocation((String)key));
        });
        this.beingWrittenOutputStream.clear();
        this.isFirstWrite.clear();
    }

    private FSDataOutputStream getOrCreateOutputStream(@NonNull String filePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        FSDataOutputStream fsDataOutputStream = this.beingWrittenOutputStream.get(filePath);
        if (fsDataOutputStream == null) {
            try {
                switch (this.compressFormat) {
                    case LZO: {
                        LzopCodec lzo = new LzopCodec();
                        CompressionOutputStream out = lzo.createOutputStream((OutputStream)this.hadoopFileSystemProxy.getOutputStream(filePath));
                        fsDataOutputStream = new FSDataOutputStream((OutputStream)out, null);
                        break;
                    }
                    case NONE: {
                        fsDataOutputStream = this.hadoopFileSystemProxy.getOutputStream(filePath);
                        break;
                    }
                    default: {
                        this.log.warn("Json file does not support this compress type: {}", (Object)this.compressFormat.getCompressCodec());
                        fsDataOutputStream = this.hadoopFileSystemProxy.getOutputStream(filePath);
                    }
                }
                this.beingWrittenOutputStream.put(filePath, fsDataOutputStream);
                this.isFirstWrite.put(filePath, true);
            }
            catch (IOException e) {
                throw CommonError.fileOperationFailed((String)"JsonFile", (String)"open", (String)filePath, (Throwable)e);
            }
        }
        return fsDataOutputStream;
    }
}

