/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.source.reader;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseSourceConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.AbstractReadStrategy;

public class BinaryReadStrategy
extends AbstractReadStrategy {
    public static SeaTunnelRowType binaryRowType = new SeaTunnelRowType(new String[]{"data", "relativePath", "partIndex"}, new SeaTunnelDataType[]{PrimitiveByteArrayType.INSTANCE, BasicType.STRING_TYPE, BasicType.LONG_TYPE});
    private File basePath;

    @Override
    public void init(HadoopConf conf) {
        super.init(conf);
        this.basePath = new File(this.pluginConfig.getString(BaseSourceConfigOptions.FILE_PATH.key()));
    }

    @Override
    public void read(String path, String tableId, Collector<SeaTunnelRow> output) throws IOException, FileConnectorException {
        try (FSDataInputStream inputStream = this.hadoopFileSystemProxy.getInputStream(path);){
            int readSize;
            String relativePath;
            if (this.basePath.isFile()) {
                relativePath = this.basePath.getName();
            } else {
                relativePath = path.substring(path.indexOf(this.basePath.getAbsolutePath()) + this.basePath.getAbsolutePath().length());
                if (relativePath.startsWith(File.separator)) {
                    relativePath = relativePath.substring(File.separator.length());
                }
            }
            int maxSize = 1024;
            byte[] buffer = new byte[maxSize];
            long partIndex = 0L;
            while ((readSize = inputStream.read(buffer)) != -1) {
                if (readSize != maxSize) {
                    buffer = Arrays.copyOf(buffer, readSize);
                }
                SeaTunnelRow row = new SeaTunnelRow(new Object[]{buffer, relativePath, partIndex});
                buffer = new byte[1024];
                output.collect((Object)row);
                ++partIndex;
            }
        }
    }

    @Override
    public SeaTunnelRowType getSeaTunnelRowTypeInfo(String path) throws FileConnectorException {
        return binaryRowType;
    }
}

