/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.source.reader;

import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.DateTimeUtils;
import org.apache.seatunnel.common.utils.DateUtils;
import org.apache.seatunnel.common.utils.TimeUtils;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseSourceConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.AbstractReadStrategy;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class ExcelReadStrategy
extends AbstractReadStrategy {
    private final DateUtils.Formatter dateFormat = DateUtils.Formatter.YYYY_MM_DD;
    private final DateTimeUtils.Formatter datetimeFormat = DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS;
    private final TimeUtils.Formatter timeFormat = TimeUtils.Formatter.HH_MM_SS;
    private int[] indexes;
    private int cellCount;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public void read(String path, String tableId, Collector<SeaTunnelRow> output) {
        Workbook workbook;
        Map<String, String> partitionsMap = this.parsePartitionsByPath(path);
        FSDataInputStream file = this.hadoopFileSystemProxy.getInputStream(path);
        if (path.endsWith(".xls")) {
            workbook = new HSSFWorkbook((InputStream)file);
        } else if (path.endsWith(".xlsx")) {
            workbook = new XSSFWorkbook((InputStream)file);
        } else {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, "Only support read excel file");
        }
        Sheet sheet = this.pluginConfig.hasPath(BaseSourceConfigOptions.SHEET_NAME.key()) ? workbook.getSheet(this.pluginConfig.getString(BaseSourceConfigOptions.SHEET_NAME.key())) : workbook.getSheetAt(0);
        this.cellCount = this.seaTunnelRowType.getTotalFields();
        this.cellCount = partitionsMap.isEmpty() ? this.cellCount : this.cellCount + partitionsMap.size();
        SeaTunnelDataType[] fieldTypes = this.seaTunnelRowType.getFieldTypes();
        int rowCount = sheet.getPhysicalNumberOfRows();
        if (this.skipHeaderNumber > Integer.MAX_VALUE || this.skipHeaderNumber < Integer.MIN_VALUE || this.skipHeaderNumber > (long)rowCount) {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, "Skip the number of rows exceeds the maximum or minimum limit of Sheet");
        }
        IntStream.range((int)this.skipHeaderNumber, rowCount).mapToObj(sheet::getRow).filter(Objects::nonNull).forEach(rowData -> {
            int[] cellIndexes = this.indexes == null ? IntStream.range(0, this.cellCount).toArray() : this.indexes;
            int z = 0;
            SeaTunnelRow seaTunnelRow = new SeaTunnelRow(this.cellCount);
            for (int j : cellIndexes) {
                Cell cell = rowData.getCell(j);
                seaTunnelRow.setField(z++, cell == null ? null : this.convert(this.getCellValue(cell.getCellType(), cell), fieldTypes[z - 1]));
            }
            if (this.isMergePartition) {
                int index = this.seaTunnelRowType.getTotalFields();
                for (String value : partitionsMap.values()) {
                    seaTunnelRow.setField(index++, (Object)value);
                }
            }
            seaTunnelRow.setTableId(tableId);
            output.collect((Object)seaTunnelRow);
        });
    }

    @Override
    public void setSeaTunnelRowTypeInfo(SeaTunnelRowType seaTunnelRowType) {
        if (this.isNullOrEmpty(seaTunnelRowType.getFieldNames()) || this.isNullOrEmpty(seaTunnelRowType.getFieldTypes())) {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, "Schmea information is not set or incorrect schmea settings");
        }
        SeaTunnelRowType userDefinedRowTypeWithPartition = this.mergePartitionTypes((String)this.fileNames.get(0), seaTunnelRowType);
        if (this.pluginConfig.hasPath(BaseSourceConfigOptions.READ_COLUMNS.key())) {
            this.indexes = new int[this.readColumns.size()];
            String[] fields = new String[this.readColumns.size()];
            SeaTunnelDataType[] types = new SeaTunnelDataType[this.readColumns.size()];
            for (int i = 0; i < this.indexes.length; ++i) {
                this.indexes[i] = seaTunnelRowType.indexOf((String)this.readColumns.get(i));
                fields[i] = seaTunnelRowType.getFieldName(this.indexes[i]);
                types[i] = seaTunnelRowType.getFieldType(this.indexes[i]);
            }
            this.seaTunnelRowType = new SeaTunnelRowType(fields, types);
            this.seaTunnelRowTypeWithPartition = this.mergePartitionTypes((String)this.fileNames.get(0), this.seaTunnelRowType);
        } else {
            this.seaTunnelRowType = seaTunnelRowType;
            this.seaTunnelRowTypeWithPartition = userDefinedRowTypeWithPartition;
        }
    }

    @Override
    public SeaTunnelRowType getSeaTunnelRowTypeInfo(String path) throws FileConnectorException {
        throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, "User must defined schema for json file type");
    }

    private Object getCellValue(CellType cellType, Cell cell) {
        switch (cellType) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted(cell)) {
                    DataFormatter formatter = new DataFormatter();
                    return formatter.formatCellValue(cell);
                }
                return cell.getNumericCellValue();
            }
            case ERROR: {
                break;
            }
            default: {
                throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, String.format("[%s] type not support ", new Object[]{cellType}));
            }
        }
        return null;
    }

    private Object convert(Object field, SeaTunnelDataType<?> fieldType) {
        if (field == null) {
            return "";
        }
        SqlType sqlType = fieldType.getSqlType();
        switch (sqlType) {
            case MAP: 
            case ARRAY: {
                return this.objectMapper.readValue((String)field, fieldType.getTypeClass());
            }
            case STRING: {
                return field;
            }
            case DOUBLE: {
                return Double.parseDouble(field.toString());
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(field.toString());
            }
            case FLOAT: {
                return Float.valueOf((float)Double.parseDouble(field.toString()));
            }
            case BIGINT: {
                return (long)Double.parseDouble(field.toString());
            }
            case INT: {
                return (int)Double.parseDouble(field.toString());
            }
            case TINYINT: {
                return (byte)Double.parseDouble(field.toString());
            }
            case SMALLINT: {
                return (short)Double.parseDouble(field.toString());
            }
            case DECIMAL: {
                return BigDecimal.valueOf(Double.parseDouble(field.toString()));
            }
            case DATE: {
                return LocalDate.parse((String)field, DateTimeFormatter.ofPattern(this.dateFormat.getValue()));
            }
            case TIME: {
                return LocalTime.parse((String)field, DateTimeFormatter.ofPattern(this.timeFormat.getValue()));
            }
            case TIMESTAMP: {
                return LocalDateTime.parse((String)field, DateTimeFormatter.ofPattern(this.datetimeFormat.getValue()));
            }
            case NULL: {
                return "";
            }
            case BYTES: {
                return field.toString().getBytes(StandardCharsets.UTF_8);
            }
            case ROW: {
                String delimiter = (String)ReadonlyConfig.fromConfig((Config)this.pluginConfig).get(BaseSourceConfigOptions.FIELD_DELIMITER);
                String[] context = field.toString().split(delimiter);
                SeaTunnelRowType ft = (SeaTunnelRowType)fieldType;
                int length = context.length;
                SeaTunnelRow seaTunnelRow = new SeaTunnelRow(length);
                for (int j = 0; j < length; ++j) {
                    seaTunnelRow.setField(j, this.convert(context[j], ft.getFieldType(j)));
                }
                return seaTunnelRow;
            }
        }
        throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "User defined schema validation failed");
    }

    private <T> boolean isNullOrEmpty(T[] arr) {
        return arr == null || arr.length == 0;
    }
}

