/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.sink.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.sink.config.FileSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.file.sink.util.XmlWriter;
import org.apache.seatunnel.connectors.seatunnel.file.sink.writer.AbstractWriteStrategy;

public class XmlWriteStrategy
extends AbstractWriteStrategy<XmlWriter> {
    private final LinkedHashMap<String, XmlWriter> beingWrittenWriter = new LinkedHashMap();

    public XmlWriteStrategy(FileSinkConfig fileSinkConfig) {
        super(fileSinkConfig);
    }

    @Override
    public void write(SeaTunnelRow seaTunnelRow) throws FileConnectorException {
        super.write(seaTunnelRow);
        String filePath = this.getOrCreateFilePathBeingWritten(seaTunnelRow);
        XmlWriter xmlDocWriter = this.getOrCreateOutputStream(filePath);
        xmlDocWriter.writeData(seaTunnelRow);
    }

    @Override
    public void finishAndCloseFile() {
        this.beingWrittenWriter.forEach((k, v) -> {
            try {
                this.hadoopFileSystemProxy.createFile((String)k);
                FSDataOutputStream fileOutputStream = this.hadoopFileSystemProxy.getOutputStream((String)k);
                v.flushAndCloseXmlWriter((OutputStream)fileOutputStream);
                fileOutputStream.close();
            }
            catch (IOException e) {
                throw CommonError.fileOperationFailed((String)"XmlFile", (String)"write", (String)k, (Throwable)e);
            }
            this.needMoveFiles.put(k, this.getTargetLocation((String)k));
        });
        this.beingWrittenWriter.clear();
    }

    @Override
    public XmlWriter getOrCreateOutputStream(String filePath) {
        return this.beingWrittenWriter.computeIfAbsent(filePath, k -> new XmlWriter(this.fileSinkConfig, this.sinkColumnsIndexInRow, this.seaTunnelRowType));
    }
}

