/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.oss.config;

import java.util.HashMap;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.oss.config.OssConfig;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class OssConf
extends HadoopConf {
    private static final String HDFS_IMPL = "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem";
    private static final String SCHEMA = "oss";

    @Override
    public String getFsHdfsImpl() {
        return HDFS_IMPL;
    }

    @Override
    public String getSchema() {
        return SCHEMA;
    }

    public OssConf(String hdfsNameKey) {
        super(hdfsNameKey);
    }

    public static HadoopConf buildWithConfig(Config config) {
        OssConf hadoopConf = new OssConf(config.getString(OssConfig.BUCKET.key()));
        HashMap<String, String> ossOptions = new HashMap<String, String>();
        ossOptions.put("fs.oss.accessKeyId", config.getString(OssConfig.ACCESS_KEY.key()));
        ossOptions.put("fs.oss.accessKeySecret", config.getString(OssConfig.ACCESS_SECRET.key()));
        ossOptions.put("fs.oss.endpoint", config.getString(OssConfig.ENDPOINT.key()));
        hadoopConf.setExtraOptions(ossOptions);
        return hadoopConf;
    }
}

