/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.file.org.apache.parquet.hadoop.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.crypto.InternalFileDecryptor;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.schema.MessageType;

public final class FileMetaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MessageType schema;
    private final Map<String, String> keyValueMetaData;
    private final String createdBy;
    private final InternalFileDecryptor fileDecryptor;

    public FileMetaData(MessageType schema, Map<String, String> keyValueMetaData, String createdBy) {
        this(schema, keyValueMetaData, createdBy, null);
    }

    public FileMetaData(MessageType schema, Map<String, String> keyValueMetaData, String createdBy, InternalFileDecryptor fileDecryptor) {
        this.schema = Objects.requireNonNull(schema, "schema cannot be null");
        this.keyValueMetaData = Collections.unmodifiableMap(Objects.requireNonNull(keyValueMetaData, "keyValueMetaData cannot be null"));
        this.createdBy = createdBy;
        this.fileDecryptor = fileDecryptor;
    }

    public MessageType getSchema() {
        return this.schema;
    }

    public String toString() {
        return "FileMetaData{schema: " + this.schema + ", metadata: " + this.keyValueMetaData + "}";
    }

    public Map<String, String> getKeyValueMetaData() {
        return this.keyValueMetaData;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public InternalFileDecryptor getFileDecryptor() {
        return this.fileDecryptor;
    }
}

