/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.s3.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.options.ConnectorCommonOptions;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileBaseSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileSystemType;
import org.apache.seatunnel.connectors.seatunnel.file.s3.config.S3FileBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.file.s3.config.S3FileSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.file.s3.source.S3FileSource;

@AutoService(value={Factory.class})
public class S3FileSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return FileSystemType.S3.getFileSystemPluginName();
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        return () -> new S3FileSource(context.getOptions());
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{S3FileSourceOptions.FILE_PATH}).required(new Option[]{S3FileSourceOptions.FILE_FORMAT_TYPE}).required(new Option[]{S3FileSourceOptions.S3_BUCKET}).required(new Option[]{S3FileSourceOptions.FS_S3A_ENDPOINT}).required(new Option[]{S3FileSourceOptions.S3A_AWS_CREDENTIALS_PROVIDER}).conditional(S3FileSourceOptions.S3A_AWS_CREDENTIALS_PROVIDER, (Object)S3FileBaseOptions.S3aAwsCredentialsProvider.SimpleAWSCredentialsProvider, new Option[]{S3FileSourceOptions.S3_ACCESS_KEY, S3FileSourceOptions.S3_SECRET_KEY}).optional(new Option[]{S3FileSourceOptions.S3_PROPERTIES}).conditional(FileBaseSourceOptions.FILE_FORMAT_TYPE, (Object)FileFormat.TEXT, new Option[]{FileBaseSourceOptions.ROW_DELIMITER, FileBaseSourceOptions.FIELD_DELIMITER, FileBaseSourceOptions.SKIP_HEADER_ROW_NUMBER}).conditional(FileBaseSourceOptions.FILE_FORMAT_TYPE, (Object)FileFormat.XML, new Option[]{FileBaseSourceOptions.XML_ROW_TAG, FileBaseSourceOptions.XML_USE_ATTR_FORMAT}).conditional(FileBaseSourceOptions.FILE_FORMAT_TYPE, (Object)FileFormat.CSV, new Option[]{FileBaseSourceOptions.SKIP_HEADER_ROW_NUMBER}).conditional(FileBaseSourceOptions.FILE_FORMAT_TYPE, Arrays.asList(FileFormat.TEXT, FileFormat.JSON, FileFormat.EXCEL, FileFormat.CSV, FileFormat.XML), new Option[]{ConnectorCommonOptions.SCHEMA}).conditional(FileBaseSourceOptions.FILE_FORMAT_TYPE, Arrays.asList(FileFormat.TEXT, FileFormat.JSON, FileFormat.CSV, FileFormat.XML), new Option[]{FileBaseSourceOptions.ENCODING}).optional(new Option[]{FileBaseSourceOptions.PARSE_PARTITION_FROM_PATH}).optional(new Option[]{FileBaseSourceOptions.DATE_FORMAT_LEGACY}).optional(new Option[]{FileBaseSourceOptions.DATETIME_FORMAT_LEGACY}).optional(new Option[]{FileBaseSourceOptions.TIME_FORMAT_LEGACY}).optional(new Option[]{FileBaseSourceOptions.FILE_FILTER_PATTERN}).optional(new Option[]{FileBaseSourceOptions.COMPRESS_CODEC}).optional(new Option[]{FileBaseSourceOptions.ARCHIVE_COMPRESS_CODEC}).optional(new Option[]{FileBaseSourceOptions.NULL_FORMAT}).optional(new Option[]{FileBaseSourceOptions.FILENAME_EXTENSION}).optional(new Option[]{FileBaseSourceOptions.READ_COLUMNS}).build();
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return S3FileSource.class;
    }
}

