/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.source.reader;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public interface ReadStrategy
extends Serializable,
Closeable {
    public void init(HadoopConf var1);

    public void read(String var1, String var2, Collector<SeaTunnelRow> var3) throws IOException, FileConnectorException;

    public SeaTunnelRowType getSeaTunnelRowTypeInfo(String var1) throws FileConnectorException;

    default public SeaTunnelRowType getSeaTunnelRowTypeInfo(TablePath tablePath, String path) throws FileConnectorException {
        return this.getSeaTunnelRowTypeInfo(path);
    }

    default public SeaTunnelRowType getSeaTunnelRowTypeInfoWithUserConfigRowType(String path, SeaTunnelRowType rowType) throws FileConnectorException {
        return this.getSeaTunnelRowTypeInfo(path);
    }

    public void setCatalogTable(CatalogTable var1);

    public List<String> getFileNamesByPath(String var1) throws IOException;

    public void setPluginConfig(Config var1);

    public SeaTunnelRowType getActualSeaTunnelRowTypeInfo();

    default public <T> void buildColumnsWithErrorCheck(TablePath tablePath, Iterator<T> keys, Consumer<T> getDataType) {
        LinkedHashMap unsupported = new LinkedHashMap();
        while (keys.hasNext()) {
            try {
                getDataType.accept(keys.next());
            }
            catch (SeaTunnelRuntimeException e) {
                if (e.getSeaTunnelErrorCode().equals(CommonErrorCode.CONVERT_TO_SEATUNNEL_TYPE_ERROR_SIMPLE)) {
                    unsupported.put(e.getParams().get("field"), e.getParams().get("dataType"));
                    continue;
                }
                throw e;
            }
        }
        if (!unsupported.isEmpty()) {
            throw CommonError.getCatalogTableWithUnsupportedType((String)this.getClass().getSimpleName().replace("ReadStrategy", ""), (String)tablePath.getFullName(), unsupported);
        }
    }
}

