/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.catalog;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.connectors.seatunnel.file.hadoop.HadoopFileSystemProxy;

public abstract class AbstractFileCatalog
implements Catalog {
    protected final String catalogName;
    private final HadoopFileSystemProxy hadoopFileSystemProxy;
    private final String filePath;

    protected AbstractFileCatalog(HadoopFileSystemProxy hadoopFileSystemProxy, String filePath, String catalogName) {
        this.catalogName = catalogName;
        this.filePath = filePath;
        this.hadoopFileSystemProxy = hadoopFileSystemProxy;
    }

    public void open() throws CatalogException {
    }

    public void close() throws CatalogException {
    }

    public String name() {
        return this.catalogName;
    }

    public String getDefaultDatabase() throws CatalogException {
        return null;
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        return false;
    }

    public List<String> listDatabases() throws CatalogException {
        return null;
    }

    public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
        return null;
    }

    public boolean tableExists(TablePath tablePath) throws CatalogException {
        return this.hadoopFileSystemProxy.fileExist(this.filePath);
    }

    public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
        return null;
    }

    public void createTable(TablePath tablePath, CatalogTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        this.hadoopFileSystemProxy.createDir(this.filePath);
    }

    public void dropTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        this.hadoopFileSystemProxy.deleteFile(this.filePath);
    }

    public void createDatabase(TablePath tablePath, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
    }

    public void dropDatabase(TablePath tablePath, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
    }

    public void truncateTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        this.hadoopFileSystemProxy.deleteFile(this.filePath);
        this.hadoopFileSystemProxy.createDir(this.filePath);
    }

    public boolean isExistsData(TablePath tablePath) {
        List<LocatedFileStatus> locatedFileStatuses = this.hadoopFileSystemProxy.listFile(this.filePath);
        return CollectionUtils.isNotEmpty(locatedFileStatuses);
    }
}

