/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.s3.catalog;

import java.io.IOException;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.connectors.seatunnel.file.hadoop.HadoopFileSystemProxy;
import org.apache.seatunnel.connectors.seatunnel.file.s3.config.S3ConfigOptions;

public class S3FileCatalog
implements Catalog {
    private final HadoopFileSystemProxy hadoopFileSystemProxy;
    private final ReadonlyConfig readonlyConfig;

    public void open() throws CatalogException {
    }

    public void close() throws CatalogException {
        if (this.hadoopFileSystemProxy != null) {
            try {
                this.hadoopFileSystemProxy.close();
            }
            catch (IOException e) {
                throw new CatalogException((Throwable)e);
            }
        }
    }

    public String name() {
        return "S3File";
    }

    public String getDefaultDatabase() throws CatalogException {
        return null;
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        return false;
    }

    public List<String> listDatabases() throws CatalogException {
        return null;
    }

    public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
        return null;
    }

    public boolean tableExists(TablePath tablePath) throws CatalogException {
        return this.hadoopFileSystemProxy.fileExist((String)this.readonlyConfig.get(S3ConfigOptions.FILE_PATH));
    }

    public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
        return null;
    }

    public void createTable(TablePath tablePath, CatalogTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        this.hadoopFileSystemProxy.createDir((String)this.readonlyConfig.get(S3ConfigOptions.FILE_PATH));
    }

    public void dropTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        this.hadoopFileSystemProxy.deleteFile((String)this.readonlyConfig.get(S3ConfigOptions.FILE_PATH));
    }

    public void createDatabase(TablePath tablePath, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
    }

    public void dropDatabase(TablePath tablePath, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
    }

    public void truncateTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        this.hadoopFileSystemProxy.deleteFile((String)this.readonlyConfig.get(S3ConfigOptions.FILE_PATH));
        this.hadoopFileSystemProxy.createDir((String)this.readonlyConfig.get(S3ConfigOptions.FILE_PATH));
    }

    public boolean isExistsData(TablePath tablePath) {
        List<LocatedFileStatus> locatedFileStatuses = this.hadoopFileSystemProxy.listFile((String)this.readonlyConfig.get(S3ConfigOptions.FILE_PATH));
        return CollectionUtils.isNotEmpty(locatedFileStatuses);
    }

    public S3FileCatalog(HadoopFileSystemProxy hadoopFileSystemProxy, ReadonlyConfig readonlyConfig) {
        this.hadoopFileSystemProxy = hadoopFileSystemProxy;
        this.readonlyConfig = readonlyConfig;
    }
}

