/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.source.split;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.file.source.split.FileSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.file.source.state.FileSourceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSourceSplitEnumerator
implements SourceSplitEnumerator<FileSourceSplit, FileSourceState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSourceSplitEnumerator.class);
    private final SourceSplitEnumerator.Context<FileSourceSplit> context;
    private final Set<FileSourceSplit> pendingSplit = new HashSet<FileSourceSplit>();
    private Set<FileSourceSplit> assignedSplit;
    private final List<String> filePaths;

    public FileSourceSplitEnumerator(SourceSplitEnumerator.Context<FileSourceSplit> context, List<String> filePaths) {
        this.context = context;
        this.filePaths = filePaths;
        this.assignedSplit = new HashSet<FileSourceSplit>();
    }

    public FileSourceSplitEnumerator(SourceSplitEnumerator.Context<FileSourceSplit> context, List<String> filePaths, FileSourceState sourceState) {
        this(context, filePaths);
        this.assignedSplit = sourceState.getAssignedSplit();
    }

    public void open() {
        this.pendingSplit.addAll(this.discoverySplits());
    }

    public void run() {
        for (int i = 0; i < this.context.currentParallelism(); ++i) {
            LOGGER.info("Assigned splits to reader [{}]", (Object)i);
            this.assignSplit(i);
        }
    }

    private Set<FileSourceSplit> discoverySplits() {
        HashSet<FileSourceSplit> fileSourceSplits = new HashSet<FileSourceSplit>();
        this.filePaths.forEach(k -> fileSourceSplits.add(new FileSourceSplit((String)k)));
        return fileSourceSplits;
    }

    public void close() throws IOException {
    }

    public void addSplitsBack(List<FileSourceSplit> splits, int subtaskId) {
        if (!splits.isEmpty()) {
            this.pendingSplit.addAll(splits);
            this.assignSplit(subtaskId);
        }
    }

    private void assignSplit(int taskId) {
        ArrayList<FileSourceSplit> currentTaskSplits = new ArrayList<FileSourceSplit>();
        if (this.context.currentParallelism() == 1) {
            currentTaskSplits.addAll(this.pendingSplit);
        } else {
            for (FileSourceSplit fileSourceSplit : this.pendingSplit) {
                int splitOwner = FileSourceSplitEnumerator.getSplitOwner(fileSourceSplit.splitId(), this.context.currentParallelism());
                if (splitOwner != taskId) continue;
                currentTaskSplits.add(fileSourceSplit);
            }
        }
        this.context.assignSplit(taskId, currentTaskSplits);
        this.assignedSplit.addAll(currentTaskSplits);
        currentTaskSplits.forEach(split -> this.pendingSplit.remove(split));
        LOGGER.info("SubTask {} is assigned to [{}]", (Object)taskId, (Object)currentTaskSplits.stream().map(FileSourceSplit::splitId).collect(Collectors.joining(",")));
        this.context.signalNoMoreSplits(taskId);
    }

    private static int getSplitOwner(String tp, int numReaders) {
        return (tp.hashCode() & Integer.MAX_VALUE) % numReaders;
    }

    public int currentUnassignedSplitSize() {
        return this.pendingSplit.size();
    }

    public void registerReader(int subtaskId) {
    }

    public FileSourceState snapshotState(long checkpointId) {
        return new FileSourceState(this.assignedSplit);
    }

    public void notifyCheckpointComplete(long checkpointId) {
    }

    public void handleSplitRequest(int subtaskId) {
    }
}

