/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.sftp.config;

import java.util.HashMap;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.sftp.config.SftpConfigOptions;

public class SftpConf
extends HadoopConf {
    private static final String HDFS_IMPL = "org.apache.seatunnel.connectors.seatunnel.file.sftp.system.SFTPFileSystem";
    private static final String SCHEMA = "sftp";

    private SftpConf(String hdfsNameKey) {
        super(hdfsNameKey);
    }

    @Override
    public String getFsHdfsImpl() {
        return HDFS_IMPL;
    }

    @Override
    public String getSchema() {
        return SCHEMA;
    }

    public static HadoopConf buildWithConfig(ReadonlyConfig config) {
        String host = (String)config.get(SftpConfigOptions.SFTP_HOST);
        int port = (Integer)config.get(SftpConfigOptions.SFTP_PORT);
        String defaultFS = String.format("sftp://%s:%s", host, port);
        SftpConf hadoopConf = new SftpConf(defaultFS);
        HashMap<String, String> sftpOptions = new HashMap<String, String>();
        sftpOptions.put("fs.sftp.user." + host, (String)config.get(SftpConfigOptions.SFTP_USER));
        sftpOptions.put("fs.sftp.password." + host + "." + (String)config.get(SftpConfigOptions.SFTP_USER), (String)config.get(SftpConfigOptions.SFTP_PASSWORD));
        hadoopConf.setExtraOptions(sftpOptions);
        return hadoopConf;
    }
}

