/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.sink.writer;

import io.airlift.compress.lzo.LzopCodec;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.seatunnel.api.serialization.SerializationSchema;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.DateTimeUtils;
import org.apache.seatunnel.common.utils.DateUtils;
import org.apache.seatunnel.common.utils.EncodingUtils;
import org.apache.seatunnel.common.utils.TimeUtils;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.sink.config.FileSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.file.sink.writer.AbstractWriteStrategy;
import org.apache.seatunnel.format.csv.CsvSerializationSchema;
import org.apache.seatunnel.format.csv.constant.CsvStringQuoteMode;

public class CsvWriteStrategy
extends AbstractWriteStrategy<FSDataOutputStream> {
    private final LinkedHashMap<String, FSDataOutputStream> beingWrittenOutputStream;
    private final Map<String, Boolean> isFirstWrite;
    private final String fieldDelimiter;
    private final String rowDelimiter;
    private final DateUtils.Formatter dateFormat;
    private final DateTimeUtils.Formatter dateTimeFormat;
    private final TimeUtils.Formatter timeFormat;
    private final FileFormat fileFormat;
    private final Boolean enableHeaderWriter;
    private final Charset charset;
    private final CsvStringQuoteMode csvStringQuoteMode;
    private SerializationSchema serializationSchema;

    public CsvWriteStrategy(FileSinkConfig fileSinkConfig) {
        super(fileSinkConfig);
        this.csvStringQuoteMode = fileSinkConfig.getCsvStringQuoteMode();
        this.beingWrittenOutputStream = new LinkedHashMap();
        this.isFirstWrite = new HashMap<String, Boolean>();
        this.fieldDelimiter = fileSinkConfig.getFieldDelimiter();
        this.rowDelimiter = fileSinkConfig.getRowDelimiter();
        this.dateFormat = fileSinkConfig.getDateFormat();
        this.dateTimeFormat = fileSinkConfig.getDatetimeFormat();
        this.timeFormat = fileSinkConfig.getTimeFormat();
        this.fileFormat = fileSinkConfig.getFileFormat();
        this.enableHeaderWriter = fileSinkConfig.getEnableHeaderWriter();
        this.charset = EncodingUtils.tryParseCharset((String)fileSinkConfig.getEncoding());
    }

    @Override
    public void setCatalogTable(CatalogTable catalogTable) {
        super.setCatalogTable(catalogTable);
        this.serializationSchema = CsvSerializationSchema.builder().seaTunnelRowType(this.buildSchemaWithRowType(catalogTable.getSeaTunnelRowType(), this.sinkColumnsIndexInRow)).delimiter(this.fieldDelimiter).dateFormatter(this.dateFormat).dateTimeFormatter(this.dateTimeFormat).timeFormatter(this.timeFormat).charset(this.charset).quoteMode(this.csvStringQuoteMode).build();
    }

    @Override
    public void write(@NonNull SeaTunnelRow seaTunnelRow) {
        if (seaTunnelRow == null) {
            throw new NullPointerException("seaTunnelRow is marked non-null but is null");
        }
        super.write(seaTunnelRow);
        String filePath = this.getOrCreateFilePathBeingWritten(seaTunnelRow);
        FSDataOutputStream fsDataOutputStream = this.getOrCreateOutputStream(filePath);
        try {
            if (this.isFirstWrite.get(filePath).booleanValue()) {
                this.isFirstWrite.put(filePath, false);
            } else {
                fsDataOutputStream.write(this.rowDelimiter.getBytes(this.charset));
            }
            fsDataOutputStream.write(this.serializationSchema.serialize(seaTunnelRow.copy(this.sinkColumnsIndexInRow.stream().mapToInt(Integer::intValue).toArray())));
        }
        catch (IOException e) {
            throw CommonError.fileOperationFailed((String)"CsvFile", (String)"write", (String)filePath, (Throwable)e);
        }
    }

    @Override
    public void finishAndCloseFile() {
        this.beingWrittenOutputStream.forEach((key, value) -> {
            try {
                value.flush();
            }
            catch (IOException e) {
                throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.FLUSH_DATA_FAILED, String.format("Flush data to this file [%s] failed", key), e);
            }
            finally {
                try {
                    value.close();
                }
                catch (IOException e) {
                    this.log.error("error when close output stream {}", key, (Object)e);
                }
            }
            this.needMoveFiles.put(key, this.getTargetLocation((String)key));
        });
        this.beingWrittenOutputStream.clear();
        this.isFirstWrite.clear();
    }

    @Override
    public FSDataOutputStream getOrCreateOutputStream(@NonNull String filePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        FSDataOutputStream fsDataOutputStream = this.beingWrittenOutputStream.get(filePath);
        if (fsDataOutputStream == null) {
            try {
                switch (this.compressFormat) {
                    case LZO: {
                        LzopCodec lzo = new LzopCodec();
                        CompressionOutputStream out = lzo.createOutputStream((OutputStream)this.hadoopFileSystemProxy.getOutputStream(filePath));
                        fsDataOutputStream = new FSDataOutputStream((OutputStream)out, null);
                        this.enableWriteHeader(fsDataOutputStream);
                        break;
                    }
                    case NONE: {
                        fsDataOutputStream = this.hadoopFileSystemProxy.getOutputStream(filePath);
                        this.enableWriteHeader(fsDataOutputStream);
                        break;
                    }
                    default: {
                        this.log.warn("Csv file does not support this compress type: {}", (Object)this.compressFormat.getCompressCodec());
                        fsDataOutputStream = this.hadoopFileSystemProxy.getOutputStream(filePath);
                        this.enableWriteHeader(fsDataOutputStream);
                    }
                }
                this.beingWrittenOutputStream.put(filePath, fsDataOutputStream);
                this.isFirstWrite.put(filePath, true);
            }
            catch (IOException e) {
                throw CommonError.fileOperationFailed((String)"CsvFile", (String)"open", (String)filePath, (Throwable)e);
            }
        }
        return fsDataOutputStream;
    }

    private void enableWriteHeader(FSDataOutputStream fsDataOutputStream) throws IOException {
        if (this.enableHeaderWriter.booleanValue()) {
            fsDataOutputStream.write(String.join((CharSequence)",", this.seaTunnelRowType.getFieldNames()).getBytes());
            fsDataOutputStream.write(this.rowDelimiter.getBytes());
        }
    }
}

