/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.sftp.catalog;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.factory.CatalogFactory;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileBaseSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileSystemType;
import org.apache.seatunnel.connectors.seatunnel.file.hadoop.HadoopFileSystemProxy;
import org.apache.seatunnel.connectors.seatunnel.file.sftp.catalog.SftpFileCatalog;
import org.apache.seatunnel.connectors.seatunnel.file.sftp.config.SftpConf;

@AutoService(value={Factory.class})
public class SftpFileCatalogFactory
implements CatalogFactory {
    public Catalog createCatalog(String catalogName, ReadonlyConfig options) {
        HadoopFileSystemProxy fileSystemUtils = new HadoopFileSystemProxy(SftpConf.buildWithConfig(options));
        return new SftpFileCatalog(fileSystemUtils, (String)options.get(FileBaseSourceOptions.FILE_PATH), this.factoryIdentifier());
    }

    public String factoryIdentifier() {
        return FileSystemType.SFTP.getFileSystemPluginName();
    }

    public OptionRule optionRule() {
        return OptionRule.builder().build();
    }
}

