/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.sftp.config;

import java.util.HashMap;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.sftp.config.SftpConfigOptions;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class SftpConf
extends HadoopConf {
    private static final String HDFS_IMPL = "org.apache.seatunnel.connectors.seatunnel.file.sftp.system.SFTPFileSystem";
    private static final String SCHEMA = "sftp";

    private SftpConf(String hdfsNameKey) {
        super(hdfsNameKey);
    }

    @Override
    public String getFsHdfsImpl() {
        return HDFS_IMPL;
    }

    @Override
    public String getSchema() {
        return SCHEMA;
    }

    public static HadoopConf buildWithConfig(Config config) {
        String host = config.getString(SftpConfigOptions.SFTP_HOST.key());
        int port = config.getInt(SftpConfigOptions.SFTP_PORT.key());
        String defaultFS = String.format("sftp://%s:%s", host, port);
        SftpConf hadoopConf = new SftpConf(defaultFS);
        HashMap<String, String> sftpOptions = new HashMap<String, String>();
        sftpOptions.put("fs.sftp.user." + host, config.getString(SftpConfigOptions.SFTP_USER.key()));
        sftpOptions.put("fs.sftp.password." + host + "." + config.getString(SftpConfigOptions.SFTP_USER.key()), config.getString(SftpConfigOptions.SFTP_PASSWORD.key()));
        hadoopConf.setExtraOptions(sftpOptions);
        return hadoopConf;
    }
}

