/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.google.sheets.com.google.common.collect;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import org.apache.seatunnel.shade.google.sheets.com.google.common.annotations.GwtCompatible;
import org.apache.seatunnel.shade.google.sheets.com.google.common.annotations.GwtIncompatible;
import org.apache.seatunnel.shade.google.sheets.com.google.common.base.Preconditions;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.AbstractMultiset;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.CollectPreconditions;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.Multiset;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.Multisets;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.ObjectCountHashMap;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.ParametricNullness;
import org.apache.seatunnel.shade.google.sheets.com.google.common.collect.Serialization;
import org.apache.seatunnel.shade.google.sheets.com.google.common.primitives.Ints;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
abstract class AbstractMapBasedMultiset<E>
extends AbstractMultiset<E>
implements Serializable {
    transient ObjectCountHashMap<E> backingMap;
    transient long size;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    AbstractMapBasedMultiset(int distinctElements) {
        this.backingMap = this.newBackingMap(distinctElements);
    }

    abstract ObjectCountHashMap<E> newBackingMap(int var1);

    @Override
    public final int count(@CheckForNull Object element) {
        return this.backingMap.get(element);
    }

    @Override
    @CanIgnoreReturnValue
    public final int add(@ParametricNullness E element, int occurrences) {
        if (occurrences == 0) {
            return this.count(element);
        }
        Preconditions.checkArgument(occurrences > 0, "occurrences cannot be negative: %s", occurrences);
        int entryIndex = this.backingMap.indexOf(element);
        if (entryIndex == -1) {
            this.backingMap.put(element, occurrences);
            this.size += (long)occurrences;
            return 0;
        }
        int oldCount = this.backingMap.getValue(entryIndex);
        long newCount = (long)oldCount + (long)occurrences;
        Preconditions.checkArgument(newCount <= Integer.MAX_VALUE, "too many occurrences: %s", newCount);
        this.backingMap.setValue(entryIndex, (int)newCount);
        this.size += (long)occurrences;
        return oldCount;
    }

    @Override
    @CanIgnoreReturnValue
    public final int remove(@CheckForNull Object element, int occurrences) {
        int numberRemoved;
        if (occurrences == 0) {
            return this.count(element);
        }
        Preconditions.checkArgument(occurrences > 0, "occurrences cannot be negative: %s", occurrences);
        int entryIndex = this.backingMap.indexOf(element);
        if (entryIndex == -1) {
            return 0;
        }
        int oldCount = this.backingMap.getValue(entryIndex);
        if (oldCount > occurrences) {
            numberRemoved = occurrences;
            this.backingMap.setValue(entryIndex, oldCount - occurrences);
        } else {
            numberRemoved = oldCount;
            this.backingMap.removeEntry(entryIndex);
        }
        this.size -= (long)numberRemoved;
        return oldCount;
    }

    @Override
    @CanIgnoreReturnValue
    public final int setCount(@ParametricNullness E element, int count) {
        CollectPreconditions.checkNonnegative(count, "count");
        int oldCount = count == 0 ? this.backingMap.remove(element) : this.backingMap.put(element, count);
        this.size += (long)(count - oldCount);
        return oldCount;
    }

    @Override
    public final boolean setCount(@ParametricNullness E element, int oldCount, int newCount) {
        CollectPreconditions.checkNonnegative(oldCount, "oldCount");
        CollectPreconditions.checkNonnegative(newCount, "newCount");
        int entryIndex = this.backingMap.indexOf(element);
        if (entryIndex == -1) {
            if (oldCount != 0) {
                return false;
            }
            if (newCount > 0) {
                this.backingMap.put(element, newCount);
                this.size += (long)newCount;
            }
            return true;
        }
        int actualOldCount = this.backingMap.getValue(entryIndex);
        if (actualOldCount != oldCount) {
            return false;
        }
        if (newCount == 0) {
            this.backingMap.removeEntry(entryIndex);
            this.size -= (long)oldCount;
        } else {
            this.backingMap.setValue(entryIndex, newCount);
            this.size += (long)(newCount - oldCount);
        }
        return true;
    }

    @Override
    public final void clear() {
        this.backingMap.clear();
        this.size = 0L;
    }

    @Override
    final Iterator<E> elementIterator() {
        return new Itr<E>(){

            @Override
            @ParametricNullness
            E result(int entryIndex) {
                return AbstractMapBasedMultiset.this.backingMap.getKey(entryIndex);
            }
        };
    }

    @Override
    final Iterator<Multiset.Entry<E>> entryIterator() {
        return new Itr<Multiset.Entry<E>>(){

            @Override
            Multiset.Entry<E> result(int entryIndex) {
                return AbstractMapBasedMultiset.this.backingMap.getEntry(entryIndex);
            }
        };
    }

    void addTo(Multiset<? super E> target) {
        Preconditions.checkNotNull(target);
        int i = this.backingMap.firstIndex();
        while (i >= 0) {
            target.add(this.backingMap.getKey(i), this.backingMap.getValue(i));
            i = this.backingMap.nextIndex(i);
        }
    }

    @Override
    final int distinctElements() {
        return this.backingMap.size();
    }

    @Override
    public final Iterator<E> iterator() {
        return Multisets.iteratorImpl(this);
    }

    @Override
    public final int size() {
        return Ints.saturatedCast(this.size);
    }

    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Serialization.writeMultiset(this, stream);
    }

    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int distinctElements = Serialization.readCount(stream);
        this.backingMap = this.newBackingMap(3);
        Serialization.populateMultiset(this, stream, distinctElements);
    }

    abstract class Itr<T>
    implements Iterator<T> {
        int entryIndex;
        int toRemove;
        int expectedModCount;

        Itr() {
            this.entryIndex = AbstractMapBasedMultiset.this.backingMap.firstIndex();
            this.toRemove = -1;
            this.expectedModCount = AbstractMapBasedMultiset.this.backingMap.modCount;
        }

        @ParametricNullness
        abstract T result(int var1);

        private void checkForConcurrentModification() {
            if (AbstractMapBasedMultiset.this.backingMap.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            this.checkForConcurrentModification();
            return this.entryIndex >= 0;
        }

        @Override
        @ParametricNullness
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T result = this.result(this.entryIndex);
            this.toRemove = this.entryIndex;
            this.entryIndex = AbstractMapBasedMultiset.this.backingMap.nextIndex(this.entryIndex);
            return result;
        }

        @Override
        public void remove() {
            this.checkForConcurrentModification();
            CollectPreconditions.checkRemove(this.toRemove != -1);
            AbstractMapBasedMultiset.this.size -= (long)AbstractMapBasedMultiset.this.backingMap.removeEntry(this.toRemove);
            this.entryIndex = AbstractMapBasedMultiset.this.backingMap.nextIndexAfterRemove(this.entryIndex, this.toRemove);
            this.toRemove = -1;
            this.expectedModCount = AbstractMapBasedMultiset.this.backingMap.modCount;
        }
    }
}

