/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.google.sheets.deserialize;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.google.sheets.deserialize.SeaTunnelRowDeserializer;
import org.apache.seatunnel.connectors.seatunnel.google.sheets.exception.GoogleSheetsConnectorException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;

public class GoogleSheetsDeserializer
implements SeaTunnelRowDeserializer {
    private final DeserializationSchema<SeaTunnelRow> deserializationSchema;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final String[] fields;

    public GoogleSheetsDeserializer(String[] fields, DeserializationSchema<SeaTunnelRow> deserializationSchema) {
        this.fields = fields;
        this.deserializationSchema = deserializationSchema;
    }

    @Override
    public SeaTunnelRow deserializeRow(List<Object> row) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 0; i < row.size(); ++i) {
                if (i >= this.fields.length) continue;
                map.put(this.fields[i], row.get(i));
            }
            String rowStr = this.objectMapper.writeValueAsString(map);
            return (SeaTunnelRow)this.deserializationSchema.deserialize(rowStr.getBytes());
        }
        catch (IOException e) {
            throw new GoogleSheetsConnectorException((SeaTunnelErrorCode)CommonErrorCode.JSON_OPERATION_FAILED, "Object json deserialization failed.", e);
        }
    }
}

