/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.google.sheets.source;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.ValueRange;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.ServiceAccountCredentials;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitReader;
import org.apache.seatunnel.connectors.seatunnel.common.source.SingleSplitReaderContext;
import org.apache.seatunnel.connectors.seatunnel.google.sheets.config.SheetsParameters;
import org.apache.seatunnel.connectors.seatunnel.google.sheets.deserialize.GoogleSheetsDeserializer;
import org.apache.seatunnel.connectors.seatunnel.google.sheets.deserialize.SeaTunnelRowDeserializer;

public class SheetsSourceReader
extends AbstractSingleSplitReader<SeaTunnelRow> {
    private SheetsParameters sheetsParameters;
    private SeaTunnelRowType seaTunnelRowType;
    private HttpRequestInitializer requestInitializer;
    private static final String APPLICATION_NAME = "SeaTunnel Google Sheets";
    private static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
    private final SingleSplitReaderContext context;
    private final SeaTunnelRowDeserializer seaTunnelRowDeserializer;

    public SheetsSourceReader(SheetsParameters sheetsParameters, SingleSplitReaderContext context, DeserializationSchema<SeaTunnelRow> deserializationSchema, SeaTunnelRowType seaTunnelRowType) throws IOException {
        this.sheetsParameters = sheetsParameters;
        this.context = context;
        this.seaTunnelRowType = seaTunnelRowType;
        this.seaTunnelRowDeserializer = new GoogleSheetsDeserializer(seaTunnelRowType.getFieldNames(), deserializationSchema);
    }

    public void open() throws Exception {
        byte[] keyBytes = Base64.getDecoder().decode(this.sheetsParameters.getServiceAccountKey());
        ServiceAccountCredentials sourceCredentials = ServiceAccountCredentials.fromStream(new ByteArrayInputStream(keyBytes));
        sourceCredentials = (ServiceAccountCredentials)sourceCredentials.createScoped(Collections.singletonList("https://www.googleapis.com/auth/spreadsheets"));
        this.requestInitializer = new HttpCredentialsAdapter(sourceCredentials);
    }

    public void close() throws IOException {
    }

    public void pollNext(Collector<SeaTunnelRow> output) throws Exception {
        NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        Sheets service = new Sheets.Builder(httpTransport, JSON_FACTORY, this.requestInitializer).setApplicationName(APPLICATION_NAME).build();
        ValueRange response = (ValueRange)service.spreadsheets().values().get(this.sheetsParameters.getSheetId(), this.sheetsParameters.getSheetName() + "!" + this.sheetsParameters.getRange()).execute();
        List<List<Object>> values = response.getValues();
        if (values != null) {
            for (List<Object> row : values) {
                SeaTunnelRow seaTunnelRow = this.seaTunnelRowDeserializer.deserializeRow(row);
                output.collect((Object)seaTunnelRow);
            }
        }
        this.context.signalNoMoreElement();
    }
}

