/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.cos.config;

import java.util.HashMap;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.cos.config.CosFileBaseOptions;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class CosConf
extends HadoopConf {
    private static final String HDFS_IMPL = "org.apache.hadoop.fs.CosFileSystem";
    private static final String SCHEMA = "cosn";

    @Override
    public String getFsHdfsImpl() {
        return HDFS_IMPL;
    }

    @Override
    public String getSchema() {
        return SCHEMA;
    }

    public CosConf(String hdfsNameKey) {
        super(hdfsNameKey);
    }

    public static HadoopConf buildWithConfig(Config config) {
        CosConf hadoopConf = new CosConf(config.getString(CosFileBaseOptions.BUCKET.key()));
        HashMap<String, String> cosOptions = new HashMap<String, String>();
        cosOptions.put("fs.cosn.userinfo.secretId", config.getString(CosFileBaseOptions.SECRET_ID.key()));
        cosOptions.put("fs.cosn.userinfo.secretKey", config.getString(CosFileBaseOptions.SECRET_KEY.key()));
        cosOptions.put("fs.cosn.bucket.region", config.getString(CosFileBaseOptions.REGION.key()));
        hadoopConf.setExtraOptions(cosOptions);
        return hadoopConf;
    }
}

