/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.hive.commit;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.sink.commit.FileAggregatedCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.file.sink.commit.FileSinkAggregatedCommitter;
import org.apache.seatunnel.connectors.seatunnel.hive.sink.HiveSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.hive.utils.HiveMetaStoreProxy;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSinkAggregatedCommitter
extends FileSinkAggregatedCommitter {
    private static final Logger log = LoggerFactory.getLogger(HiveSinkAggregatedCommitter.class);
    private final String dbName;
    private final String tableName;
    private final boolean abortDropPartitionMetadata;
    private final ReadonlyConfig readonlyConfig;
    private final HiveMetaStoreProxy hiveMetaStore;

    public HiveSinkAggregatedCommitter(ReadonlyConfig readonlyConfig, String dbName, String tableName, HadoopConf hadoopConf) {
        super(hadoopConf);
        this.readonlyConfig = readonlyConfig;
        this.hiveMetaStore = new HiveMetaStoreProxy(readonlyConfig);
        this.dbName = dbName;
        this.tableName = tableName;
        this.abortDropPartitionMetadata = (Boolean)readonlyConfig.get(HiveSinkOptions.ABORT_DROP_PARTITION_METADATA);
    }

    @Override
    public List<FileAggregatedCommitInfo> commit(List<FileAggregatedCommitInfo> aggregatedCommitInfos) throws IOException {
        List<FileAggregatedCommitInfo> errorCommitInfos = super.commit(aggregatedCommitInfos);
        if (errorCommitInfos.isEmpty()) {
            for (FileAggregatedCommitInfo aggregatedCommitInfo : aggregatedCommitInfos) {
                LinkedHashMap<String, List<String>> partitionDirAndValuesMap = aggregatedCommitInfo.getPartitionDirAndValuesMap();
                List<String> partitions = partitionDirAndValuesMap.keySet().stream().map(partition -> partition.replaceAll("\\\\", "/")).collect(Collectors.toList());
                try {
                    this.hiveMetaStore.addPartitions(this.dbName, this.tableName, partitions);
                    log.info("Add these partitions {}", partitions);
                }
                catch (TException e) {
                    log.error("Failed to add these partitions {}", partitions, (Object)e);
                    errorCommitInfos.add(aggregatedCommitInfo);
                }
            }
        }
        return errorCommitInfos;
    }

    @Override
    public void abort(List<FileAggregatedCommitInfo> aggregatedCommitInfos) throws Exception {
        super.abort(aggregatedCommitInfos);
        if (this.abortDropPartitionMetadata) {
            for (FileAggregatedCommitInfo aggregatedCommitInfo : aggregatedCommitInfos) {
                LinkedHashMap<String, List<String>> partitionDirAndValuesMap = aggregatedCommitInfo.getPartitionDirAndValuesMap();
                List<String> partitions = partitionDirAndValuesMap.keySet().stream().map(partition -> partition.replaceAll("\\\\", "/")).collect(Collectors.toList());
                try {
                    this.hiveMetaStore.dropPartitions(this.dbName, this.tableName, partitions);
                    log.info("Remove these partitions {}", partitions);
                }
                catch (TException e) {
                    log.error("Failed to remove these partitions {}", partitions, (Object)e);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.hiveMetaStore.close();
        }
        finally {
            super.close();
        }
    }
}

