/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.hive.source.config;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.options.ConnectorCommonOptions;
import org.apache.seatunnel.connectors.seatunnel.hive.source.config.HiveSourceConfig;
import org.apache.seatunnel.shade.com.google.common.collect.Lists;

public class MultipleTableHiveSourceConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<HiveSourceConfig> hiveSourceConfigs;

    public MultipleTableHiveSourceConfig(ReadonlyConfig readonlyConfig) {
        if (readonlyConfig.getOptional(ConnectorCommonOptions.TABLE_LIST).isPresent()) {
            this.parseFromLocalFileSourceByTableList(readonlyConfig);
        } else if (readonlyConfig.getOptional(ConnectorCommonOptions.TABLE_CONFIGS).isPresent()) {
            this.parseFromLocalFileSourceByTableConfigs(readonlyConfig);
        } else {
            this.parseFromLocalFileSourceConfig(readonlyConfig);
        }
    }

    private void parseFromLocalFileSourceByTableList(ReadonlyConfig readonlyConfig) {
        this.hiveSourceConfigs = ((List)readonlyConfig.get(ConnectorCommonOptions.TABLE_LIST)).stream().map(ReadonlyConfig::fromMap).map(HiveSourceConfig::new).collect(Collectors.toList());
    }

    @Deprecated
    private void parseFromLocalFileSourceByTableConfigs(ReadonlyConfig readonlyConfig) {
        this.hiveSourceConfigs = ((List)readonlyConfig.get(ConnectorCommonOptions.TABLE_CONFIGS)).stream().map(ReadonlyConfig::fromMap).map(HiveSourceConfig::new).collect(Collectors.toList());
    }

    private void parseFromLocalFileSourceConfig(ReadonlyConfig localFileSourceRootConfig) {
        HiveSourceConfig hiveSourceConfig = new HiveSourceConfig(localFileSourceRootConfig);
        this.hiveSourceConfigs = Lists.newArrayList((Object[])new HiveSourceConfig[]{hiveSourceConfig});
    }

    public List<HiveSourceConfig> getHiveSourceConfigs() {
        return this.hiveSourceConfigs;
    }
}

