/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.hive.utils;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.file.hadoop.HadoopLoginFactory;
import org.apache.seatunnel.connectors.seatunnel.file.hdfs.source.config.HdfsSourceConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.hive.config.HiveConfig;
import org.apache.seatunnel.connectors.seatunnel.hive.config.HiveOptions;
import org.apache.seatunnel.connectors.seatunnel.hive.exception.HiveConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.hive.exception.HiveConnectorException;
import org.apache.seatunnel.connectors.seatunnel.hive.utils.HiveMetaStoreProxyUtils;
import org.apache.seatunnel.shade.com.google.common.collect.ImmutableList;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaStoreProxy
implements Closeable,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(HiveMetaStoreProxy.class);
    private static final List<String> HADOOP_CONF_FILES = ImmutableList.of((Object)"hive-site.xml");
    private final String metastoreUri;
    private final String hadoopConfDir;
    private final String hiveSitePath;
    private final boolean kerberosEnabled;
    private final boolean remoteUserEnabled;
    private final String krb5Path;
    private final String principal;
    private final String keytabPath;
    private final String remoteUser;
    private transient HiveMetaStoreClient hiveClient;

    public HiveMetaStoreProxy(ReadonlyConfig config) {
        this.metastoreUri = (String)config.get(HiveOptions.METASTORE_URI);
        this.hadoopConfDir = (String)config.get(HiveConfig.HADOOP_CONF_PATH);
        this.hiveSitePath = (String)config.get(HiveConfig.HIVE_SITE_PATH);
        this.kerberosEnabled = HiveMetaStoreProxyUtils.enableKerberos(config);
        this.remoteUserEnabled = HiveMetaStoreProxyUtils.enableRemoteUser(config);
        this.krb5Path = (String)config.get(HdfsSourceConfigOptions.KRB5_PATH);
        this.principal = (String)config.get(HdfsSourceConfigOptions.KERBEROS_PRINCIPAL);
        this.keytabPath = (String)config.get(HdfsSourceConfigOptions.KERBEROS_KEYTAB_PATH);
        this.remoteUser = (String)config.get(HdfsSourceConfigOptions.REMOTE_USER);
    }

    private synchronized HiveMetaStoreClient getClient() {
        if (this.hiveClient == null) {
            this.hiveClient = this.initializeClient();
        }
        return this.hiveClient;
    }

    private HiveMetaStoreClient initializeClient() {
        HiveConf hiveConf = this.buildHiveConf();
        try {
            if (this.kerberosEnabled) {
                return this.loginWithKerberos(hiveConf);
            }
            if (this.remoteUserEnabled) {
                return this.loginWithRemoteUser(hiveConf);
            }
            return new HiveMetaStoreClient((Configuration)hiveConf);
        }
        catch (Exception e) {
            String errMsg = String.format("Failed to initialize HiveMetaStoreClient [uris=%s, hiveSite=%s]", this.metastoreUri, this.hiveSitePath);
            throw new HiveConnectorException(HiveConnectorErrorCode.INITIALIZE_HIVE_METASTORE_CLIENT_FAILED, errMsg, e);
        }
    }

    private HiveConf buildHiveConf() {
        HiveConf hiveConf = new HiveConf();
        hiveConf.set("hive.metastore.uris", this.metastoreUri);
        if (StringUtils.isNotBlank(this.hadoopConfDir)) {
            for (String fileName : HADOOP_CONF_FILES) {
                Path path = Paths.get(this.hadoopConfDir, fileName);
                if (!Files.exists(path, new LinkOption[0])) continue;
                try {
                    hiveConf.addResource(path.toUri().toURL());
                }
                catch (IOException e) {
                    log.warn("Error adding Hadoop config {}", (Object)path, (Object)e);
                }
            }
        }
        if (StringUtils.isNotBlank(this.hiveSitePath)) {
            try {
                hiveConf.addResource(new File(this.hiveSitePath).toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.warn("Invalid hiveSitePath {}", (Object)this.hiveSitePath, (Object)e);
            }
        }
        log.info("Hive client configuration: {}", (Object)hiveConf);
        return hiveConf;
    }

    private HiveMetaStoreClient loginWithKerberos(HiveConf hiveConf) throws Exception {
        Configuration authConf = new Configuration();
        authConf.set("hadoop.security.authentication", "kerberos");
        return HadoopLoginFactory.loginWithKerberos(authConf, this.krb5Path, this.principal, this.keytabPath, (conf, ugi) -> new HiveMetaStoreClient((Configuration)hiveConf));
    }

    private HiveMetaStoreClient loginWithRemoteUser(HiveConf hiveConf) throws Exception {
        return HadoopLoginFactory.loginWithRemoteUser(new Configuration(), this.remoteUser, (conf, ugi) -> new HiveMetaStoreClient((Configuration)hiveConf));
    }

    public Table getTable(@NonNull String dbName, @NonNull String tableName) {
        if (dbName == null) {
            throw new NullPointerException("dbName is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        try {
            return this.getClient().getTable(dbName, tableName);
        }
        catch (TException e) {
            String msg = String.format("Failed to get table %s.%s", dbName, tableName);
            throw new HiveConnectorException(HiveConnectorErrorCode.GET_HIVE_TABLE_INFORMATION_FAILED, msg, e);
        }
    }

    public void addPartitions(@NonNull String dbName, @NonNull String tableName, List<String> partitions) throws TException {
        if (dbName == null) {
            throw new NullPointerException("dbName is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        for (String partition : partitions) {
            try {
                this.getClient().appendPartition(dbName, tableName, partition);
            }
            catch (AlreadyExistsException ae) {
                log.warn("Partition {} already exists", (Object)partition);
            }
        }
    }

    public void dropPartitions(@NonNull String dbName, @NonNull String tableName, List<String> partitions) throws TException {
        if (dbName == null) {
            throw new NullPointerException("dbName is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        for (String partition : partitions) {
            this.getClient().dropPartition(dbName, tableName, partition, false);
        }
    }

    @Override
    public synchronized void close() {
        if (Objects.nonNull(this.hiveClient)) {
            this.hiveClient.close();
        }
    }
}

