/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.hive.org.apache.orc.storage.common;

import java.util.Arrays;
import java.util.BitSet;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.storage.common.ValidTxnList;

public class ValidReadTxnList
implements ValidTxnList {
    protected long[] exceptions;
    protected BitSet abortedBits;
    private long minOpenTxn = Long.MAX_VALUE;
    protected long highWatermark;

    public ValidReadTxnList() {
        this(new long[0], new BitSet(), Long.MAX_VALUE, Long.MAX_VALUE);
    }

    public ValidReadTxnList(long[] exceptions, BitSet abortedBits, long highWatermark) {
        this(exceptions, abortedBits, highWatermark, Long.MAX_VALUE);
    }

    public ValidReadTxnList(long[] exceptions, BitSet abortedBits, long highWatermark, long minOpenTxn) {
        if (exceptions.length > 0) {
            this.minOpenTxn = minOpenTxn;
        }
        this.exceptions = exceptions;
        this.abortedBits = abortedBits;
        this.highWatermark = highWatermark;
    }

    public ValidReadTxnList(String value) {
        this.readFromString(value);
    }

    @Override
    public boolean isTxnValid(long txnid) {
        if (txnid > this.highWatermark) {
            return false;
        }
        return Arrays.binarySearch(this.exceptions, txnid) < 0;
    }

    @Override
    public ValidTxnList.RangeResponse isTxnRangeValid(long minTxnId, long maxTxnId) {
        if (minTxnId > this.highWatermark) {
            return ValidTxnList.RangeResponse.NONE;
        }
        if (this.exceptions.length > 0 && this.exceptions[0] > maxTxnId) {
            return ValidTxnList.RangeResponse.ALL;
        }
        long count = Math.max(0L, maxTxnId - this.highWatermark);
        for (long txn : this.exceptions) {
            if (minTxnId > txn || txn > maxTxnId) continue;
            ++count;
        }
        if (count == 0L) {
            return ValidTxnList.RangeResponse.ALL;
        }
        if (count == maxTxnId - minTxnId + 1L) {
            return ValidTxnList.RangeResponse.NONE;
        }
        return ValidTxnList.RangeResponse.SOME;
    }

    public String toString() {
        return this.writeToString();
    }

    @Override
    public String writeToString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.highWatermark);
        buf.append(':');
        buf.append(this.minOpenTxn);
        if (this.exceptions.length == 0) {
            buf.append(':');
            buf.append(':');
        } else {
            StringBuilder open = new StringBuilder();
            StringBuilder abort = new StringBuilder();
            for (int i = 0; i < this.exceptions.length; ++i) {
                if (this.abortedBits.get(i)) {
                    if (abort.length() > 0) {
                        abort.append(',');
                    }
                    abort.append(this.exceptions[i]);
                    continue;
                }
                if (open.length() > 0) {
                    open.append(',');
                }
                open.append(this.exceptions[i]);
            }
            buf.append(':');
            buf.append((CharSequence)open);
            buf.append(':');
            buf.append((CharSequence)abort);
        }
        return buf.toString();
    }

    @Override
    public void readFromString(String src) {
        if (src == null || src.length() == 0) {
            this.highWatermark = Long.MAX_VALUE;
            this.exceptions = new long[0];
            this.abortedBits = new BitSet();
        } else {
            String[] values = src.split(":");
            this.highWatermark = Long.parseLong(values[0]);
            this.minOpenTxn = Long.parseLong(values[1]);
            String[] openTxns = new String[]{};
            String[] abortedTxns = new String[]{};
            if (values.length < 3) {
                openTxns = new String[]{};
                abortedTxns = new String[]{};
            } else if (values.length == 3) {
                if (!values[2].isEmpty()) {
                    openTxns = values[2].split(",");
                }
            } else {
                if (!values[2].isEmpty()) {
                    openTxns = values[2].split(",");
                }
                if (!values[3].isEmpty()) {
                    abortedTxns = values[3].split(",");
                }
            }
            this.exceptions = new long[openTxns.length + abortedTxns.length];
            int i = 0;
            for (String open : openTxns) {
                this.exceptions[i++] = Long.parseLong(open);
            }
            for (String abort : abortedTxns) {
                this.exceptions[i++] = Long.parseLong(abort);
            }
            Arrays.sort(this.exceptions);
            this.abortedBits = new BitSet(this.exceptions.length);
            for (String abort : abortedTxns) {
                int index = Arrays.binarySearch(this.exceptions, Long.parseLong(abort));
                this.abortedBits.set(index);
            }
        }
    }

    @Override
    public long getHighWatermark() {
        return this.highWatermark;
    }

    @Override
    public long[] getInvalidTransactions() {
        return this.exceptions;
    }

    @Override
    public Long getMinOpenTxn() {
        return this.minOpenTxn == Long.MAX_VALUE ? null : Long.valueOf(this.minOpenTxn);
    }

    @Override
    public boolean isTxnAborted(long txnid) {
        int index = Arrays.binarySearch(this.exceptions, txnid);
        return index >= 0 && this.abortedBits.get(index);
    }

    @Override
    public ValidTxnList.RangeResponse isTxnRangeAborted(long minTxnId, long maxTxnId) {
        long abortedTxnId;
        if (this.highWatermark < minTxnId) {
            return ValidTxnList.RangeResponse.NONE;
        }
        int count = 0;
        int i = this.abortedBits.nextSetBit(0);
        while (i >= 0 && (abortedTxnId = this.exceptions[i]) <= maxTxnId) {
            if (abortedTxnId >= minTxnId && abortedTxnId <= maxTxnId) {
                ++count;
            }
            i = this.abortedBits.nextSetBit(i + 1);
        }
        if (count == 0) {
            return ValidTxnList.RangeResponse.NONE;
        }
        if ((long)count == maxTxnId - minTxnId + 1L) {
            return ValidTxnList.RangeResponse.ALL;
        }
        return ValidTxnList.RangeResponse.SOME;
    }
}

