/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.hive.org.apache.parquet.column.values.bloomfilter;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Arrays;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.Preconditions;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.column.values.bloomfilter.HashFunction;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.column.values.bloomfilter.XxHash;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.io.api.Binary;

public class BlockSplitBloomFilter
implements BloomFilter {
    private static final int BYTES_PER_BLOCK = 32;
    private static final int BITS_PER_BLOCK = 256;
    public static final int LOWER_BOUND_BYTES = 32;
    public static final int UPPER_BOUND_BYTES = 0x8000000;
    private static final int BITS_SET_PER_BLOCK = 8;
    public static final int HEADER_SIZE = 16;
    public static final double DEFAULT_FPP = 0.01;
    private final BloomFilter.HashStrategy hashStrategy;
    private byte[] bitset;
    private IntBuffer intBuffer;
    private HashFunction hashFunction;
    private int maximumBytes = 0x8000000;
    private int minimumBytes = 32;
    private ByteBuffer cacheBuffer = ByteBuffer.allocate(8);
    private int[] mask = new int[8];
    private static final int[] SALT = new int[]{1203114875, 1150766481, -2010862245, -1565054819, 1884591559, 770785867, -1627633337, 1550580529};

    public BlockSplitBloomFilter(int numBytes) {
        this(numBytes, 32, 0x8000000, BloomFilter.HashStrategy.XXH64);
    }

    public BlockSplitBloomFilter(int numBytes, int maximumBytes) {
        this(numBytes, 32, maximumBytes, BloomFilter.HashStrategy.XXH64);
    }

    private BlockSplitBloomFilter(int numBytes, BloomFilter.HashStrategy hashStrategy) {
        this(numBytes, 32, 0x8000000, hashStrategy);
    }

    public BlockSplitBloomFilter(int numBytes, int minimumBytes, int maximumBytes, BloomFilter.HashStrategy hashStrategy) {
        if (minimumBytes > maximumBytes) {
            throw new IllegalArgumentException("the minimum bytes should be less or equal than maximum bytes");
        }
        if (minimumBytes > 32 && minimumBytes < 0x8000000) {
            this.minimumBytes = minimumBytes;
        }
        if (maximumBytes > 32 && maximumBytes < 0x8000000) {
            this.maximumBytes = maximumBytes;
        }
        this.initBitset(numBytes);
        this.cacheBuffer.order(ByteOrder.LITTLE_ENDIAN);
        switch (hashStrategy) {
            case XXH64: {
                this.hashStrategy = hashStrategy;
                this.hashFunction = new XxHash();
                break;
            }
            default: {
                throw new RuntimeException("Unsupported hash strategy");
            }
        }
    }

    public BlockSplitBloomFilter(byte[] bitset) {
        this(bitset, BloomFilter.HashStrategy.XXH64);
    }

    private BlockSplitBloomFilter(byte[] bitset, BloomFilter.HashStrategy hashStrategy) {
        if (bitset == null) {
            throw new RuntimeException("Given bitset is null");
        }
        this.cacheBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.bitset = bitset;
        this.intBuffer = ByteBuffer.wrap(bitset).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        switch (hashStrategy) {
            case XXH64: {
                this.hashStrategy = hashStrategy;
                this.hashFunction = new XxHash();
                break;
            }
            default: {
                throw new RuntimeException("Unsupported hash strategy");
            }
        }
    }

    private void initBitset(int numBytes) {
        if (numBytes < this.minimumBytes) {
            numBytes = this.minimumBytes;
        }
        if ((numBytes & numBytes - 1) != 0) {
            numBytes = Integer.highestOneBit(numBytes) << 1;
        }
        if (numBytes > this.maximumBytes || numBytes < 0) {
            numBytes = this.maximumBytes;
        }
        this.bitset = new byte[numBytes];
        this.intBuffer = ByteBuffer.wrap(this.bitset).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this.bitset);
    }

    private int[] setMask(int key) {
        int i;
        for (i = 0; i < 8; ++i) {
            this.mask[i] = key * SALT[i];
        }
        for (i = 0; i < 8; ++i) {
            this.mask[i] = this.mask[i] >>> 27;
        }
        for (i = 0; i < 8; ++i) {
            this.mask[i] = 1 << this.mask[i];
        }
        return this.mask;
    }

    @Override
    public void insertHash(long hash) {
        long numBlocks = this.bitset.length / 32;
        long lowHash = hash >>> 32;
        int blockIndex = (int)(lowHash * numBlocks >> 32);
        int key = (int)hash;
        int[] mask = this.setMask(key);
        for (int i = 0; i < 8; ++i) {
            int value = this.intBuffer.get(blockIndex * 8 + i);
            this.intBuffer.put(blockIndex * 8 + i, value |= mask[i]);
        }
    }

    @Override
    public boolean findHash(long hash) {
        long numBlocks = this.bitset.length / 32;
        long lowHash = hash >>> 32;
        int blockIndex = (int)(lowHash * numBlocks >> 32);
        int key = (int)hash;
        int[] mask = this.setMask(key);
        for (int i = 0; i < 8; ++i) {
            if (0 != (this.intBuffer.get(blockIndex * 8 + i) & mask[i])) continue;
            return false;
        }
        return true;
    }

    public static int optimalNumOfBits(long n, double p) {
        Preconditions.checkArgument(p > 0.0 && p < 1.0, "FPP should be less than 1.0 and great than 0.0");
        double m = (double)(-8L * n) / Math.log(1.0 - Math.pow(p, 0.125));
        int numBits = (int)m;
        if (numBits > 0x40000000 || m < 0.0) {
            numBits = 0x40000000;
        }
        if ((numBits = numBits + 256 - 1 & 0xFFFFFEFF) < 256) {
            numBits = 256;
        }
        return numBits;
    }

    @Override
    public int getBitsetSize() {
        return this.bitset.length;
    }

    @Override
    public long hash(Object value) {
        if (value instanceof Binary) {
            return this.hashFunction.hashBytes(((Binary)value).getBytes());
        }
        if (value instanceof Integer) {
            this.cacheBuffer.putInt((Integer)value);
        } else if (value instanceof Long) {
            this.cacheBuffer.putLong((Long)value);
        } else if (value instanceof Float) {
            this.cacheBuffer.putFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.cacheBuffer.putDouble((Double)value);
        } else {
            throw new RuntimeException("Parquet Bloom filter: Not supported type");
        }
        return this.doHash();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BlockSplitBloomFilter) {
            BlockSplitBloomFilter that = (BlockSplitBloomFilter)object;
            return Arrays.equals(this.bitset, that.bitset) && this.getAlgorithm() == that.getAlgorithm() && this.hashStrategy == that.hashStrategy;
        }
        return false;
    }

    @Override
    public BloomFilter.HashStrategy getHashStrategy() {
        return BloomFilter.HashStrategy.XXH64;
    }

    @Override
    public BloomFilter.Algorithm getAlgorithm() {
        return BloomFilter.Algorithm.BLOCK;
    }

    @Override
    public BloomFilter.Compression getCompression() {
        return BloomFilter.Compression.UNCOMPRESSED;
    }

    private long doHash() {
        this.cacheBuffer.flip();
        long hashResult = this.hashFunction.hashByteBuffer(this.cacheBuffer);
        this.cacheBuffer.clear();
        return hashResult;
    }

    @Override
    public long hash(int value) {
        this.cacheBuffer.putInt(value);
        return this.doHash();
    }

    @Override
    public long hash(long value) {
        this.cacheBuffer.putLong(value);
        return this.doHash();
    }

    @Override
    public long hash(double value) {
        this.cacheBuffer.putDouble(value);
        return this.doHash();
    }

    @Override
    public long hash(float value) {
        this.cacheBuffer.putFloat(value);
        return this.doHash();
    }

    @Override
    public long hash(Binary value) {
        return this.hashFunction.hashBytes(value.getBytes());
    }
}

