/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.hive.org.apache.parquet.internal.column.columnindex;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.filter2.predicate.Statistics;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.internal.column.columnindex.ColumnIndexBuilder;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.io.api.Binary;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.schema.PrimitiveComparator;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.schema.PrimitiveType;
import org.apache.seatunnel.shade.connector.hive.shaded.parquet.it.unimi.dsi.fastutil.floats.FloatArrayList;
import org.apache.seatunnel.shade.connector.hive.shaded.parquet.it.unimi.dsi.fastutil.floats.FloatList;

class FloatColumnIndexBuilder
extends ColumnIndexBuilder {
    private final FloatList minValues = new FloatArrayList();
    private final FloatList maxValues = new FloatArrayList();
    private boolean invalid;

    FloatColumnIndexBuilder() {
    }

    private static float convert(ByteBuffer buffer) {
        return buffer.order(ByteOrder.LITTLE_ENDIAN).getFloat(0);
    }

    private static ByteBuffer convert(float value) {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(0, value);
    }

    @Override
    void addMinMaxFromBytes(ByteBuffer min, ByteBuffer max) {
        this.minValues.add(FloatColumnIndexBuilder.convert(min));
        this.maxValues.add(FloatColumnIndexBuilder.convert(max));
    }

    @Override
    void addMinMax(Object min, Object max) {
        float fMin = ((Float)min).floatValue();
        float fMax = ((Float)max).floatValue();
        if (Float.isNaN(fMin) || Float.isNaN(fMax)) {
            this.invalid = true;
        }
        if (Float.compare(fMin, 0.0f) == 0) {
            fMin = -0.0f;
        }
        if (Float.compare(fMax, -0.0f) == 0) {
            fMax = 0.0f;
        }
        this.minValues.add(fMin);
        this.maxValues.add(fMax);
    }

    ColumnIndexBuilder.ColumnIndexBase<Float> createColumnIndex(PrimitiveType type) {
        if (this.invalid) {
            return null;
        }
        FloatColumnIndex columnIndex = new FloatColumnIndex(type);
        FloatColumnIndex.access$102(columnIndex, this.minValues.toFloatArray());
        FloatColumnIndex.access$202(columnIndex, this.maxValues.toFloatArray());
        return columnIndex;
    }

    @Override
    void clearMinMax() {
        this.minValues.clear();
        this.maxValues.clear();
    }

    @Override
    int compareMinValues(PrimitiveComparator<Binary> comparator, int index1, int index2) {
        return comparator.compare(this.minValues.get(index1).floatValue(), this.minValues.get(index2).floatValue());
    }

    @Override
    int compareMaxValues(PrimitiveComparator<Binary> comparator, int index1, int index2) {
        return comparator.compare(this.maxValues.get(index1).floatValue(), this.maxValues.get(index2).floatValue());
    }

    @Override
    int sizeOf(Object value) {
        return 4;
    }

    private static class FloatColumnIndex
    extends ColumnIndexBuilder.ColumnIndexBase<Float> {
        private float[] minValues;
        private float[] maxValues;

        private FloatColumnIndex(PrimitiveType type) {
            super(type);
        }

        @Override
        ByteBuffer getMinValueAsBytes(int pageIndex) {
            return FloatColumnIndexBuilder.convert(this.minValues[pageIndex]);
        }

        @Override
        ByteBuffer getMaxValueAsBytes(int pageIndex) {
            return FloatColumnIndexBuilder.convert(this.maxValues[pageIndex]);
        }

        @Override
        String getMinValueAsString(int pageIndex) {
            return this.stringifier.stringify(this.minValues[pageIndex]);
        }

        @Override
        String getMaxValueAsString(int pageIndex) {
            return this.stringifier.stringify(this.maxValues[pageIndex]);
        }

        @Override
        <T extends Comparable<T>> Statistics<T> createStats(int arrayIndex) {
            return new Statistics<Float>(Float.valueOf(this.minValues[arrayIndex]), Float.valueOf(this.maxValues[arrayIndex]), this.comparator);
        }

        @Override
        ColumnIndexBuilder.ColumnIndexBase.ValueComparator createValueComparator(Object value) {
            final float v = ((Float)value).floatValue();
            return new ColumnIndexBuilder.ColumnIndexBase.ValueComparator(){

                @Override
                int compareValueToMin(int arrayIndex) {
                    return comparator.compare(v, minValues[arrayIndex]);
                }

                @Override
                int compareValueToMax(int arrayIndex) {
                    return comparator.compare(v, maxValues[arrayIndex]);
                }
            };
        }

        static /* synthetic */ float[] access$102(FloatColumnIndex x0, float[] x1) {
            x0.minValues = x1;
            return x1;
        }

        static /* synthetic */ float[] access$202(FloatColumnIndex x0, float[] x1) {
            x0.maxValues = x1;
            return x1;
        }
    }
}

