/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.hive.org.apache.parquet.internal.column.columnindex;

import java.util.Formatter;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.seatunnel.shade.connector.hive.shaded.parquet.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.apache.seatunnel.shade.connector.hive.shaded.parquet.it.unimi.dsi.fastutil.ints.IntList;
import org.apache.seatunnel.shade.connector.hive.shaded.parquet.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.apache.seatunnel.shade.connector.hive.shaded.parquet.it.unimi.dsi.fastutil.longs.LongList;

public class OffsetIndexBuilder {
    private static final OffsetIndexBuilder NO_OP_BUILDER = new OffsetIndexBuilder(){

        @Override
        public void add(int compressedPageSize, long rowCount) {
        }

        @Override
        public void add(long offset, int compressedPageSize, long rowCount) {
        }
    };
    private final LongList offsets = new LongArrayList();
    private final IntList compressedPageSizes = new IntArrayList();
    private final LongList firstRowIndexes = new LongArrayList();
    private long previousOffset;
    private int previousPageSize;
    private long previousRowIndex;
    private long previousRowCount;

    public static OffsetIndexBuilder getNoOpBuilder() {
        return NO_OP_BUILDER;
    }

    public static OffsetIndexBuilder getBuilder() {
        return new OffsetIndexBuilder();
    }

    private OffsetIndexBuilder() {
    }

    public void add(int compressedPageSize, long rowCount) {
        this.add(this.previousOffset + (long)this.previousPageSize, compressedPageSize, this.previousRowIndex + this.previousRowCount);
        this.previousRowCount = rowCount;
    }

    public void add(long offset, int compressedPageSize, long firstRowIndex) {
        this.previousOffset = offset;
        this.offsets.add(offset);
        this.previousPageSize = compressedPageSize;
        this.compressedPageSizes.add(compressedPageSize);
        this.previousRowIndex = firstRowIndex;
        this.firstRowIndexes.add(firstRowIndex);
    }

    public OffsetIndex build() {
        return this.build(0L);
    }

    public OffsetIndexBuilder fromOffsetIndex(OffsetIndex offsetIndex) {
        assert (offsetIndex instanceof OffsetIndexImpl);
        OffsetIndexImpl offsetIndexImpl = (OffsetIndexImpl)offsetIndex;
        this.offsets.addAll(new LongArrayList(offsetIndexImpl.offsets));
        this.compressedPageSizes.addAll(new IntArrayList(offsetIndexImpl.compressedPageSizes));
        this.firstRowIndexes.addAll(new LongArrayList(offsetIndexImpl.firstRowIndexes));
        this.previousOffset = 0L;
        this.previousPageSize = 0;
        this.previousRowIndex = 0L;
        this.previousRowCount = 0L;
        return this;
    }

    public OffsetIndex build(long shift) {
        if (this.compressedPageSizes.isEmpty()) {
            return null;
        }
        long[] offsets = this.offsets.toLongArray();
        if (shift != 0L) {
            int i = 0;
            int n = offsets.length;
            while (i < n) {
                int n2 = i++;
                offsets[n2] = offsets[n2] + shift;
            }
        }
        OffsetIndexImpl offsetIndex = new OffsetIndexImpl();
        OffsetIndexImpl.access$102(offsetIndex, offsets);
        OffsetIndexImpl.access$202(offsetIndex, this.compressedPageSizes.toIntArray());
        OffsetIndexImpl.access$302(offsetIndex, this.firstRowIndexes.toLongArray());
        return offsetIndex;
    }

    private static class OffsetIndexImpl
    implements OffsetIndex {
        private long[] offsets;
        private int[] compressedPageSizes;
        private long[] firstRowIndexes;

        private OffsetIndexImpl() {
        }

        public String toString() {
            try (Formatter formatter = new Formatter();){
                formatter.format("%-10s  %20s  %16s  %20s\n", "", "offset", "compressed size", "first row index");
                int n = this.offsets.length;
                for (int i = 0; i < n; ++i) {
                    formatter.format("page-%-5d  %20d  %16d  %20d\n", i, this.offsets[i], this.compressedPageSizes[i], this.firstRowIndexes[i]);
                }
                String string = formatter.toString();
                return string;
            }
        }

        @Override
        public int getPageCount() {
            return this.offsets.length;
        }

        @Override
        public long getOffset(int pageIndex) {
            return this.offsets[pageIndex];
        }

        @Override
        public int getCompressedPageSize(int pageIndex) {
            return this.compressedPageSizes[pageIndex];
        }

        @Override
        public long getFirstRowIndex(int pageIndex) {
            return this.firstRowIndexes[pageIndex];
        }

        @Override
        public int getPageOrdinal(int pageIndex) {
            return pageIndex;
        }

        static /* synthetic */ long[] access$102(OffsetIndexImpl x0, long[] x1) {
            x0.offsets = x1;
            return x1;
        }

        static /* synthetic */ int[] access$202(OffsetIndexImpl x0, int[] x1) {
            x0.compressedPageSizes = x1;
            return x1;
        }

        static /* synthetic */ long[] access$302(OffsetIndexImpl x0, long[] x1) {
            x0.firstRowIndexes = x1;
            return x1;
        }
    }
}

