/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.s3.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.schema.TableSchemaOptions;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseSourceConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileSystemType;
import org.apache.seatunnel.connectors.seatunnel.file.s3.config.S3ConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.file.s3.source.S3FileSource;

@AutoService(value={Factory.class})
public class S3FileSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return FileSystemType.S3.getFileSystemPluginName();
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        return () -> new S3FileSource(context.getOptions());
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{S3ConfigOptions.FILE_PATH}).required(new Option[]{S3ConfigOptions.FILE_FORMAT_TYPE}).required(new Option[]{S3ConfigOptions.S3_BUCKET}).required(new Option[]{S3ConfigOptions.FS_S3A_ENDPOINT}).required(new Option[]{S3ConfigOptions.S3A_AWS_CREDENTIALS_PROVIDER}).conditional(S3ConfigOptions.S3A_AWS_CREDENTIALS_PROVIDER, (Object)S3ConfigOptions.S3aAwsCredentialsProvider.SimpleAWSCredentialsProvider, new Option[]{S3ConfigOptions.S3_ACCESS_KEY, S3ConfigOptions.S3_SECRET_KEY}).optional(new Option[]{S3ConfigOptions.S3_PROPERTIES}).conditional(BaseSourceConfigOptions.FILE_FORMAT_TYPE, (Object)FileFormat.TEXT, new Option[]{BaseSourceConfigOptions.FIELD_DELIMITER}).conditional(BaseSourceConfigOptions.FILE_FORMAT_TYPE, (Object)FileFormat.XML, new Option[]{BaseSourceConfigOptions.XML_ROW_TAG, BaseSourceConfigOptions.XML_USE_ATTR_FORMAT}).conditional(BaseSourceConfigOptions.FILE_FORMAT_TYPE, Arrays.asList(FileFormat.TEXT, FileFormat.JSON, FileFormat.EXCEL, FileFormat.CSV, FileFormat.XML), new Option[]{TableSchemaOptions.SCHEMA}).optional(new Option[]{BaseSourceConfigOptions.PARSE_PARTITION_FROM_PATH}).optional(new Option[]{BaseSourceConfigOptions.DATE_FORMAT}).optional(new Option[]{BaseSourceConfigOptions.DATETIME_FORMAT}).optional(new Option[]{BaseSourceConfigOptions.TIME_FORMAT}).optional(new Option[]{BaseSourceConfigOptions.FILE_FILTER_PATTERN}).optional(new Option[]{BaseSourceConfigOptions.COMPRESS_CODEC}).build();
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return S3FileSource.class;
    }
}

