/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.hive.utils;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.file.hadoop.HadoopLoginFactory;
import org.apache.seatunnel.connectors.seatunnel.file.hdfs.source.config.HdfsSourceConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.hive.config.HiveConfig;
import org.apache.seatunnel.connectors.seatunnel.hive.exception.HiveConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.hive.exception.HiveConnectorException;
import org.apache.seatunnel.connectors.seatunnel.hive.source.config.HiveSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.hive.utils.HiveMetaStoreProxyUtils;
import org.apache.seatunnel.shade.com.google.common.collect.ImmutableList;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaStoreProxy {
    private static final Logger log = LoggerFactory.getLogger(HiveMetaStoreProxy.class);
    private HiveMetaStoreClient hiveMetaStoreClient;
    private static volatile HiveMetaStoreProxy INSTANCE = null;
    private static final List<String> HADOOP_CONF_FILES = ImmutableList.of((Object)"hive-site.xml");

    private HiveMetaStoreProxy(ReadonlyConfig readonlyConfig) {
        String metastoreUri = (String)readonlyConfig.get(HiveSourceOptions.METASTORE_URI);
        String hiveHadoopConfigPath = (String)readonlyConfig.get(HiveConfig.HADOOP_CONF_PATH);
        String hiveSitePath = (String)readonlyConfig.get(HiveConfig.HIVE_SITE_PATH);
        HiveConf hiveConf = new HiveConf();
        hiveConf.set("hive.metastore.uris", metastoreUri);
        try {
            if (StringUtils.isNotBlank(hiveHadoopConfigPath)) {
                HADOOP_CONF_FILES.forEach(confFile -> {
                    Path path = Paths.get(hiveHadoopConfigPath, confFile);
                    if (Files.exists(path, new LinkOption[0])) {
                        try {
                            hiveConf.addResource(path.toUri().toURL());
                        }
                        catch (IOException e) {
                            log.warn("Error adding Hadoop resource {}, resource was not added", (Object)path, (Object)e);
                        }
                    }
                });
            }
            if (StringUtils.isNotBlank(hiveSitePath)) {
                hiveConf.addResource(new File(hiveSitePath).toURI().toURL());
            }
            log.info("hive client conf:{}", (Object)hiveConf);
            if (HiveMetaStoreProxyUtils.enableKerberos(readonlyConfig)) {
                Configuration authConf = new Configuration();
                authConf.set("hadoop.security.authentication", "kerberos");
                this.hiveMetaStoreClient = HadoopLoginFactory.loginWithKerberos(authConf, (String)readonlyConfig.get(HdfsSourceConfigOptions.KRB5_PATH), (String)readonlyConfig.get(HdfsSourceConfigOptions.KERBEROS_PRINCIPAL), (String)readonlyConfig.get(HdfsSourceConfigOptions.KERBEROS_KEYTAB_PATH), (conf, userGroupInformation) -> new HiveMetaStoreClient((Configuration)hiveConf));
                return;
            }
            if (HiveMetaStoreProxyUtils.enableRemoteUser(readonlyConfig)) {
                this.hiveMetaStoreClient = HadoopLoginFactory.loginWithRemoteUser(new Configuration(), (String)readonlyConfig.get(HdfsSourceConfigOptions.REMOTE_USER), (conf, userGroupInformation) -> new HiveMetaStoreClient((Configuration)hiveConf));
                return;
            }
            this.hiveMetaStoreClient = new HiveMetaStoreClient((Configuration)hiveConf);
        }
        catch (MetaException e) {
            String errorMsg = String.format("Using this hive uris [%s] to initialize hive metastore client instance failed", metastoreUri);
            throw new HiveConnectorException(HiveConnectorErrorCode.INITIALIZE_HIVE_METASTORE_CLIENT_FAILED, errorMsg, e);
        }
        catch (MalformedURLException e) {
            String errorMsg = String.format("Using this hive uris [%s], hive conf [%s] to initialize hive metastore client instance failed", metastoreUri, readonlyConfig.get(HiveSourceOptions.HIVE_SITE_PATH));
            throw new HiveConnectorException(HiveConnectorErrorCode.INITIALIZE_HIVE_METASTORE_CLIENT_FAILED, errorMsg, e);
        }
        catch (Exception e) {
            throw new HiveConnectorException(HiveConnectorErrorCode.INITIALIZE_HIVE_METASTORE_CLIENT_FAILED, "Login form kerberos failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HiveMetaStoreProxy getInstance(ReadonlyConfig readonlyConfig) {
        if (INSTANCE != null) return INSTANCE;
        Class<HiveMetaStoreProxy> clazz = HiveMetaStoreProxy.class;
        synchronized (HiveMetaStoreProxy.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new HiveMetaStoreProxy(readonlyConfig);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public Table getTable(@NonNull String dbName, @NonNull String tableName) {
        if (dbName == null) {
            throw new NullPointerException("dbName is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        try {
            return this.hiveMetaStoreClient.getTable(dbName, tableName);
        }
        catch (TException e) {
            String errorMsg = String.format("Get table [%s.%s] information failed", dbName, tableName);
            throw new HiveConnectorException(HiveConnectorErrorCode.GET_HIVE_TABLE_INFORMATION_FAILED, errorMsg, e);
        }
    }

    public void addPartitions(@NonNull String dbName, @NonNull String tableName, List<String> partitions) throws TException {
        if (dbName == null) {
            throw new NullPointerException("dbName is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        for (String partition : partitions) {
            try {
                this.hiveMetaStoreClient.appendPartition(dbName, tableName, partition);
            }
            catch (AlreadyExistsException e) {
                log.warn("The partition {} are already exists", (Object)partition);
            }
        }
    }

    public void dropPartitions(@NonNull String dbName, @NonNull String tableName, List<String> partitions) throws TException {
        if (dbName == null) {
            throw new NullPointerException("dbName is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        for (String partition : partitions) {
            this.hiveMetaStoreClient.dropPartition(dbName, tableName, partition, false);
        }
    }

    public synchronized void close() {
        if (Objects.nonNull(this.hiveMetaStoreClient)) {
            this.hiveMetaStoreClient.close();
            INSTANCE = null;
        }
    }
}

